package com.alibaba.druid.sql.dialect.sqlserver.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLServerSelectSubqueryTableSource extends SQLSubqueryTableSource implements SQLServerSelectTableSource, SQLServerObject {
   protected SQLServerPivotBase pivot;
   protected String pivotAlias;

   public SQLServerSelectSubqueryTableSource() {
   }

   public SQLServerSelectSubqueryTableSource(String alias) {
      super(alias);
   }

   public SQLServerSelectSubqueryTableSource(SQLSelect select, String alias) {
      super(select, alias);
   }

   public SQLServerSelectSubqueryTableSource(SQLSelect select) {
      super(select);
   }

   public SQLServerPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(SQLServerPivotBase pivot) {
      this.pivot = pivot;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getHints());
         this.acceptChild(visitor, this.select);
         this.acceptChild(visitor, this.pivot);
         this.acceptChild(visitor, this.flashback);
      }

      visitor.endVisit(this);
   }

   public String toString() {
      return SQLUtils.toSQLServerString(this);
   }

   public SQLServerSelectSubqueryTableSource clone() {
      SQLServerSelectSubqueryTableSource x = new SQLServerSelectSubqueryTableSource();
      this.cloneTo(x);
      if (this.pivot != null) {
         this.setParent(this.pivot.clone());
      }

      x.setPivotAlias(this.pivotAlias);
      return x;
   }

   public String getPivotAlias() {
      return this.pivotAlias;
   }

   public void setPivotAlias(String pivotAlias) {
      this.pivotAlias = pivotAlias;
   }
}
