package com.palacesun.engine.common;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClientUtil {
   public static ExecutorService executorService = Executors.newFixedThreadPool(10);

   public static String doClient(String url, String json) {
      String result = "调用" + url + "接口结束！";
      InnerThread innerThread = new InnerThread();
      innerThread.url = url;
      innerThread.json = json;
      innerThread.start();
      return result;
   }

   public static CloseableHttpClient buildHttpClient() {
      return EncryptionGatewayManager.getParameterValue("gatewayurl").contains("https") ? SkipHttpsUtil.wrapClient() : HttpClients.createDefault();
   }

   public static String doPost(String url, String json) {
      CloseableHttpClient httpClient = buildHttpClient();
      HttpPost httpPost = new HttpPost(url);
      String result = null;

      try {
         httpPost.setHeader("content-type", "application/json;charset=UTF-8");
         StringEntity se = new StringEntity(json, "utf-8");
         httpPost.setEntity(se);
         HttpResponse response = httpClient.execute(httpPost);
         HttpEntity entity = response.getEntity();
         if (entity != null) {
            result = EntityUtils.toString(entity, "UTF-8");
         }
      } catch (ClientProtocolException var20) {
      } catch (UnsupportedEncodingException var21) {
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            httpClient.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return result;
   }

   public static String doPost(String url, String json, GatewaySocketCallback callback) {
      CloseableHttpClient httpClient = buildHttpClient();
      HttpPost httpPost = new HttpPost(url);
      String result = null;
      String resultStatus = "";

      try {
         httpPost.setHeader("content-type", "application/json;charset=UTF-8");
         StringEntity se = new StringEntity(json, "utf-8");
         httpPost.setEntity(se);
         HttpResponse response = httpClient.execute(httpPost);
         HttpEntity entity = response.getEntity();
         if (entity != null) {
            result = EntityUtils.toString(entity, "UTF-8");
         }

         JSONObject jsonObject = JSONObject.parseObject(result);
         String data = (String)jsonObject.get("data");
         if (!jsonObject.get("code").equals("OOW_01")) {
            if ("refresh".equals(data)) {
               resultStatus = "refresh";
            } else {
               resultStatus = "norefresh";
            }

            callback.isSucc(data);
         } else {
            callback.clean();
         }
      } catch (ClientProtocolException var24) {
         callback.isFail();
         result = "noRefresh";
      } catch (UnsupportedEncodingException var25) {
         callback.isFail();
         result = "noRefresh";
      } catch (Exception e) {
         e.printStackTrace();
         callback.isFail();
         result = "noRefresh";
      } finally {
         try {
            httpClient.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return resultStatus;
   }

   public static CloseableHttpClient getWrapClient() {
      return EncryptionGatewayManager.getParameterValue("gatewayurl").contains("https") ? SkipHttpsUtil.wrapClient() : HttpClients.createDefault();
   }

   public static void main(String[] args) {
      String url = "http://192.168.2.88:8182/initconfigfile/loadconfig";
      String result = doClient(url, "{}");
      Map stringToMap = JSONObject.parseObject(result);
      System.out.println("result:" + result);
   }

   public static class InnerThread extends Thread {
      String url;
      String json;

      public void run() {
         ClientUtil.doPost(this.url, this.json);
      }
   }
}
