package com.palacesun.engine.logging.format;

public class HexEncodedBinaryFormat implements BinaryFormat {
   private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
   private static final int QUOTE_COUNT = 2;

   public String toString(byte[] input) {
      char[] result = new char[2 + input.length * 2];
      int i = 0;
      result[i++] = '\'';
      hexEncode(input, result, i);
      result[result.length - 1] = '\'';
      return new String(result);
   }

   static void hexEncode(byte[] input, char[] output, int outputOffset) {
      int idx = outputOffset;

      for(byte b : input) {
         int temp = b & 255;
         output[idx++] = HEX_CHARS[temp / 16];
         output[idx++] = HEX_CHARS[temp % 16];
      }

   }
}
