package com.palacesun.engine.spy.option;

import com.palacesun.engine.spy.P6ModuleManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class SystemProperties implements P6OptionsSource {
   public static final String P6SPY_PREFIX = "p6spy.config.";

   public Map<String, String> getOptions() {
      Map<String, String> result = new HashMap();

       Properties props = (Properties) System.getProperties().clone();
       for (Map.Entry<Object, Object> entry : props.entrySet()) {
           String key = entry.getKey().toString();
           if (key.startsWith(P6SPY_PREFIX)) {
               result.put(key.substring(P6SPY_PREFIX.length()), entry.getValue().toString());
           }
       }

      return result;
   }

   public void postInit(P6ModuleManager p6moduleManager) {
   }

   public void preDestroy(P6ModuleManager p6moduleManager) {
   }
}
