package com.palacesun.masking.appuser;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.alibaba.fastjson.JSONObject;
import com.palacesun.masking.tools.Base64;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletAppLoginUserFilter implements Filter {
   protected static Logger logger = Logger.getLogger(ServletAppLoginUserFilter.class.getName());
   public String appUri = null;
   public String usernamePosition = null;
   public String isBase64 = null;
   public String userNameParam = null;
   public String userName = null;
   private HttpLoginParamsReceive httpLoginParamsReceive = new HttpLoginParamsReceive();

   public void init(FilterConfig config) throws ServletException {
      this.appUri = EncryptionGatewayManager.getParameterValue("appUri");
      this.usernamePosition = EncryptionGatewayManager.getParameterValue("usernamePosition");
      this.isBase64 = EncryptionGatewayManager.getParameterValue("isBase64");
      this.userNameParam = EncryptionGatewayManager.getParameterValue("userNameParam");
      logger.info("@@插件----filter初始化appUri：" + this.appUri);
   }

   public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
      HttpServletRequest httpRequest = (HttpServletRequest)request;
      CachedBodyHttpServletRequest repeatableRequest = null;
      String uri = httpRequest.getRequestURI();
      RuleLoadUtil.writeLog("@@插件----doFilter---appUri：" + uri);
      if (uri.contains(this.appUri)) {
         System.out.println("@@插件---------->app_uri：" + uri);
         RuleLoadUtil.writeLog("@@插件----doFilter1---appUri：" + this.appUri);
         if ("1".equals(this.usernamePosition)) {
            this.userName = this.getIsBase64(httpRequest.getHeader(this.userNameParam));
         } else if ("2".equals(this.usernamePosition)) {
            this.userName = this.getIsBase64(httpRequest.getParameter(this.userNameParam));
            RuleLoadUtil.writeLog("@@插件----doFilter2---appUri：" + this.userName);
            if (null == this.userName || "".equals(this.userName)) {
               repeatableRequest = new CachedBodyHttpServletRequest(httpRequest);
               String postData = repeatableRequest.getBody();
               RuleLoadUtil.writeLog("@@插件----doFilter3---appUri：" + postData);
               if (postData != null && !"".equals(postData)) {
                  JSONObject jsonObject = JSONObject.parseObject(postData);
                  this.userName = (String)jsonObject.get(this.userNameParam);
                  RuleLoadUtil.writeLog("@@插件----doFilter4---appUri：" + this.userName);
               }
            }
         }

         if (this.userName != null && !"".equals(this.userName)) {
            HttpSession session = httpRequest.getSession();
            session.setAttribute("focusWays_username", this.userName);
            RuleLoadUtil.writeLog("@@插件---------->userName：" + this.userName);
         }
      }

      if (repeatableRequest != null) {
         chain.doFilter(repeatableRequest, response);
      } else {
         chain.doFilter(request, response);
      }

   }

   public String getIsBase64(String userName) {
      try {
         if ("1".equals(this.isBase64)) {
            userName = new String(Base64.getDecoder().decode(userName));
         }

         return userName;
      } catch (Exception var3) {
         return userName;
      }
   }

   public void destroy() {
   }
}
