package com.palacesun.masking.log.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LogConfig {
   private String prefix;
   private String path;
   private String mqIp;
   private int mqPort;
   private String mqQueue;
   private String mqVirtualHost;
   private String mqUserName;
   private String mqPassword;

   public static LogConfig getConfig() throws IOException {
      InputStream stream = LogConfig.class.getResourceAsStream("/accessLog.properties");
      Properties props = new Properties();
      props.load(stream);
      LogConfig config = new LogConfig();
      config.setMqIp(props.getProperty("rabbitmq.ip"));
      config.setMqPort(Integer.valueOf(props.getProperty("rabbitmq.port", "5672")));
      config.setMqVirtualHost(props.getProperty("rabbitmq.virtualHost"));
      config.setMqQueue(props.getProperty("rabbitmq.queue", "accessLog"));
      config.setMqUserName(props.getProperty("rabbitmq.username"));
      config.setMqPassword(props.getProperty("rabbitmq.password"));
      return config;
   }

   public String getPrefix() {
      return this.prefix;
   }

   public void setPrefix(String prefix) {
      this.prefix = prefix;
   }

   public String getPath() {
      return this.path;
   }

   public void setPath(String path) {
      this.path = path;
   }

   public String getMqIp() {
      return this.mqIp;
   }

   public void setMqIp(String mqIp) {
      this.mqIp = mqIp;
   }

   public int getMqPort() {
      return this.mqPort;
   }

   public void setMqPort(int mqPort) {
      this.mqPort = mqPort;
   }

   public String getMqQueue() {
      return this.mqQueue;
   }

   public void setMqQueue(String mqQueue) {
      this.mqQueue = mqQueue;
   }

   public String getMqVirtualHost() {
      return this.mqVirtualHost;
   }

   public void setMqVirtualHost(String mqVirtualHost) {
      this.mqVirtualHost = mqVirtualHost;
   }

   public String getMqUserName() {
      return this.mqUserName;
   }

   public void setMqUserName(String mqUserName) {
      this.mqUserName = mqUserName;
   }

   public String getMqPassword() {
      return this.mqPassword;
   }

   public void setMqPassword(String mqPassword) {
      this.mqPassword = mqPassword;
   }
}
