package com.palacesun.masking.tools.sm4fpe;

import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPECompany extends SM4FPEBase {
   static ArrayList<SM4FPEEntity> companyEntities = new ArrayList();
   static char[] excludeChars = new char[]{'股', '份', '有', '限', '公', '司'};
   static ArrayList chineseCharsCompany;
   static ArrayList otherChineseCharsCompany;
   static HashMap chineseCharsCompanyMap;
   static HashMap otherChineseCharsCompanyMap;
   private static Pattern companyNamePattern;

   public String encryptEcb(String hexKey, String a) throws Exception {
      String out = this.encrypt(hexKey, a, companyEntities);
      return out;
   }

   public String decryptEcb(String hexKey, String input) throws Exception {
      String out = this.decrypt(hexKey, input, companyEntities);
      return out;
   }

   public static boolean isCompanyName(String companyName) {
      boolean result = false;
      int length = companyName.length();
      if (length >= 3) {
         if (null == companyNamePattern) {
            companyNamePattern = Pattern.compile("(公司|有限公司|股份有限公司)$");
         }

         Matcher matcher = companyNamePattern.matcher(companyName);
         if (matcher.find() && matcher.start() > 0 && matcher.end() == length) {
            result = true;
         }
      }

      return result;
   }

   public int initTypes(String input, int m, SegmentType[] types, ArrayList<SM4FPEEntity> entities) throws Exception {
      int typeIndex = 0;
      int endIndex = input.length();
      if (input.endsWith("股份有限公司")) {
         endIndex -= 6;
      } else if (input.endsWith("有限公司")) {
         endIndex -= 4;
      } else if (input.endsWith("公司")) {
         endIndex -= 2;
      }

      for(int i = 0; i < endIndex; ++i) {
         int j;
         for(j = 0; j < entities.size(); ++j) {
            Integer index = (Integer)((SM4FPEEntity)entities.get(j)).getCharsMap().get(input.charAt(i));
            if (index != null) {
               types[typeIndex++].type = j;
               break;
            }
         }

         if (j == entities.size()) {
            types[typeIndex++].type = 99999;
         }
      }

      for(int i = endIndex; i < input.length(); ++i) {
         types[typeIndex++].type = 99999;
      }

      return typeIndex++;
   }

   String generateInputRandom(String input) {
      Random random = new Random();

      for(int i = 0; i < 10; ++i) {
         input = input + ((SM4FPEEntity)companyEntities.get(0)).getList().get(random.nextInt(((SM4FPEEntity)companyEntities.get(0)).getList().size()));
      }

      input = input + "股份有限公司";
      return input;
   }

   public static boolean check(String input) {
      return isCompanyName(input);
   }

   static {
      Security.addProvider(new BouncyCastleProvider());
      chineseCharsCompany = excludeChars(toArrayList(chineseChars), excludeChars);
      otherChineseCharsCompany = excludeChars(otherChineseChars, excludeChars);
      chineseCharsCompanyMap = new HashMap();

      for(int i = 0; i < chineseCharsCompany.size(); ++i) {
         chineseCharsCompanyMap.put(chineseCharsCompany.get(i), i);
      }

      otherChineseCharsCompanyMap = new HashMap();

      for(int i = 0; i < otherChineseCharsCompany.size(); ++i) {
         otherChineseCharsCompanyMap.put(otherChineseCharsCompany.get(i), i);
      }

      try {
         companyEntities.add(new SM4FPEEntity(0, chineseCharsCompany, chineseCharsCompanyMap));
         companyEntities.add(new SM4FPEEntity(1, otherChineseCharsCompany, otherChineseCharsCompanyMap));
         checkDuplicate(companyEntities);
      } catch (RuntimeException e) {
         throw e;
      }
   }
}
