package com.palacesun.masking.tools.sm4fpe;

import java.util.Map;

public class SM4FPENameUtil {
   public static String generateKey() {
      SM4FPEBase base = new SM4FPEBase();
      return base.generateKey();
   }

   public static String encryptEcb(String hexKey, String a, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(a, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPEName.check(middle)) {
         SM4FPEName name = new SM4FPEName();
         out = name.encryptEcb(hexKey, middle);
         if (!SM4FPEName.check(out)) {
            System.out.println("The encrypt result must be isPersonName. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }

   public static String decryptEcb(String hexKey, String input, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(input, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPEName.check(middle)) {
         SM4FPEName name = new SM4FPEName();
         out = name.decryptEcb(hexKey, middle);
         if (!SM4FPEName.check(out)) {
            System.out.println("The decrypt result must be isPersonName. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }
}
