package util.sqlparse.visitor.common;

import bean.Synonym;
import java.util.List;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ScopeDialector {
   protected Scope scope;

   public ScopeDialector() {
   }

   public ScopeDialector(Scope scope) {
      this.scope = scope;
   }

   public abstract boolean expandAllColumns(TableMemo var1, boolean var2, List<FieldMemo> var3);

   public abstract ScopeDialector clone(Scope var1);

   public String wrap(String text) {
      return text;
   }

   public String wrapColumn(String schema, String table, String column) {
      return this.wrap(column);
   }

   public String wrapAlias(String text) {
      return text;
   }

   public boolean isSystemTable(String table) {
      return table.equalsIgnoreCase("dual");
   }

   public boolean isEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else {
         return name1 == null && name2 == null ? true : name1.equalsIgnoreCase(name2);
      }
   }

   public List<FieldMemo> getColumns(TableMemo table) {
      return null;
   }

   public boolean isColumnEqual(String name1, String name2) {
      return this.isEqual(name1, name2);
   }

   public boolean addField(FieldMemo field) {
      return false;
   }

   public void addConflits(List<FieldMemo> fields) {
   }

   public Synonym getSynonym(String schema, String synonymName) {
      return null;
   }
}
