package util.sqlparse.visitor.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import util.sqlparse.visitor.common.ID;

public class SeqMap<K, V extends ID> extends LinkedHashMap<K, V> {
   public List<V> orderValues() {
      List<V> values = new ArrayList(this.values());
      Collections.sort(values, new Operator());
      return values;
   }

   class Operator implements Comparator<V> {
      public int compare(V a, V b) {
         return a.id < b.id ? -1 : (a.id == b.id ? 0 : 1);
      }
   }
}
