package util.sqlparse.visitor.dm.visitor;

import java.util.List;
import util.sqlparse.visitor.common.ScopeDialector;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;

public class DmScopeDialector extends ScopeDialector {
   public DmScopeDialector() {
   }

   public DmScopeDialector(Scope scope) {
      super(scope);
   }

   public String wrap(String text) {
      if (text == null) {
         return text;
      } else {
         return this.scope.context.getDataBase().isCaseSensitive() && text.startsWith("\"") ? text : text.toUpperCase();
      }
   }

   public boolean expandAllColumns(TableMemo table, boolean isSub, List<FieldMemo> fields) {
      return true;
   }

   public ScopeDialector clone(Scope scope) {
      return new DmScopeDialector(scope);
   }

   public String wrapColumn(String schema, String table, String column) {
      boolean caseSensitive = this.scope.context.getDataBase().isCaseSensitive();
      return caseSensitive ? "\"" + column + "\"" : super.wrapColumn(schema, table, column);
   }

   public boolean isEqual(String name1, String name2) {
      if (name1 == null && name2 != null) {
         return false;
      } else if (name1 != null && name2 == null) {
         return false;
      } else if (name1 == null && name2 == null) {
         return true;
      } else {
         String placeholder = "\"";
         if (name1.startsWith(placeholder) && !name2.startsWith(placeholder)) {
            return false;
         } else if (!name1.startsWith(placeholder) && name2.startsWith(placeholder)) {
            return false;
         } else {
            return name1.startsWith(placeholder) && name2.startsWith(placeholder) ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
         }
      }
   }
}
