package util.sqlparse.visitor.es.visitor;

import bean.Column;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.SqlUtil;

public class ElasticSchemaVisitor extends SchemaStatVisitor {
   Map<TableStat.Name, TableStat> tables;
   List<TableStat.Column> columns;
   private Map params;

   public Map getParams() {
      return this.params;
   }

   public void setParams(Map params) {
      this.params = params;
   }

   public void parse(String body) {
      SqlUtil util = new SqlUtil();
      this.params.put("sql", body);
      Map map = util.parseSqlStructure(this.params);
      Map<String, String> tableMap = (Map)map.get("tableMap");
      List<Column> columnList = (List)map.get("columnList");
      this.columns = new ArrayList();
      this.tables = new HashMap();

      for(Map.Entry<String, String> entry : tableMap.entrySet()) {
         String key = (String)entry.getKey();
         TableStat.Name name = new TableStat.Name(key);
         this.tables.put(name, new TableStat());
      }

      for(Column column : columnList) {
         TableStat.Column col = new TableStat.Column(column.getTable(), column.getColumnName(), DbType.elastic_search);
         this.columns.add(col);
      }

   }

   public Set<TableStat.Column> getGroupByColumns() {
      return new HashSet();
   }

   public Map<TableStat.Name, TableStat> getTables() {
      return this.tables;
   }

   public Collection<TableStat.Column> getColumns() {
      return this.columns;
   }
}
