package util.sqlparse.visitor.mongo;

import org.bson.BsonString;
import org.bson.BsonValue;

public class BsonKeyNode extends BsonNode {
   private BsonObjectNode container;
   private BsonString ref;

   public BsonKeyNode() {
   }

   public BsonKeyNode(String name, BsonObjectNode container) {
      super(name);
      this.container = container;
   }

   public Object value() {
      return this.name;
   }

   public void value(Object raw, Object... other) {
      if (raw != null && !raw.toString().equals(this.name)) {
         this.ref = new BsonString(raw.toString());
         MongoNode node = this.container.get(this.name);
         BsonValue data = node.data();
         MongoNode newNode = BsonNode.create(node.getName(), data);
         this.container.remove(this.name);
         this.name = raw.toString();
         this.container.put(this.name, newNode);
      }

   }

   public BsonValue data() {
      return this.ref;
   }

   public BsonObjectNode getContainer() {
      return this.container;
   }

   public void setContainer(BsonObjectNode container) {
      this.container = container;
   }

   public BsonString getRef() {
      return this.ref;
   }

   public void setRef(BsonString ref) {
      this.ref = ref;
   }

   public BsonNodeType type() {
      return BsonNodeType.Key;
   }

   public MongoNode clone() throws CloneNotSupportedException {
      throw new CloneNotSupportedException();
   }
}
