package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLDoubleExpr extends SQLNumericLiteralExpr implements SQLValuableExpr, Comparable<SQLDoubleExpr> {
   public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("DOUBLE");
   private double value;

   public SQLDoubleExpr() {
   }

   public SQLDoubleExpr(String value) {
      this.value = Double.parseDouble(value);
   }

   public SQLDoubleExpr(double value) {
      this.value = value;
   }

   public SQLDoubleExpr clone() {
      return new SQLDoubleExpr(this.value);
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }

   public Double getNumber() {
      return this.value;
   }

   public Double getValue() {
      return this.value;
   }

   public void setValue(double value) {
      this.value = value;
   }

   protected void accept0(SQLASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SQLDoubleExpr that = (SQLDoubleExpr)o;
         return Double.compare(that.value, this.value) == 0;
      } else {
         return false;
      }
   }

   public int hashCode() {
      long temp = Double.doubleToLongBits(this.value);
      return (int)(temp ^ temp >>> 32);
   }

   public void setNumber(Number number) {
      if (number == null) {
         this.setValue(Double.NaN);
      } else {
         this.setValue(number.doubleValue());
      }
   }

   public int compareTo(SQLDoubleExpr o) {
      return Double.compare(this.value, o.value);
   }
}
