package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableReOrganizePartition extends SQLObjectImpl implements SQLAlterTableItem {
   private final List<SQLName> names = new ArrayList();
   private final List<SQLObject> partitions = new ArrayList(4);

   public List<SQLObject> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLObject partition) {
      if (partition != null) {
         partition.setParent(this);
      }

      this.partitions.add(partition);
   }

   public List<SQLName> getNames() {
      return this.names;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitions);
      }

      visitor.endVisit(this);
   }
}
