package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLShowProcessListStatement extends SQLStatementImpl implements SQLShowStatement {
   protected boolean mpp;
   private SQLExpr where;
   private SQLOrderBy orderBy;
   private SQLLimit limit;
   private boolean full = false;

   public boolean isMpp() {
      return this.mpp;
   }

   public void setMpp(boolean mpp) {
      this.mpp = mpp;
   }

   public boolean isFull() {
      return this.full;
   }

   public void setFull(boolean full) {
      this.full = full;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.limit);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getWhere() {
      return this.where;
   }

   public void setWhere(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.where = x;
   }

   public SQLOrderBy getOrderBy() {
      return this.orderBy;
   }

   public void setOrderBy(SQLOrderBy x) {
      if (x != null) {
         x.setParent(this);
      }

      this.orderBy = x;
   }

   public SQLLimit getLimit() {
      return this.limit;
   }

   public void setLimit(SQLLimit x) {
      if (x != null) {
         x.setParent(this);
      }

      this.limit = x;
   }
}
