package com.alibaba.druid.sql.dialect.db2.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class DB2DeleteStatement extends SQLDeleteStatement implements DB2SQLStatement {
   private boolean returning;
   protected List<SQLTableSource> usingList;

   public DB2DeleteStatement() {
      super(DbType.db2);
   }

   public boolean isReturning() {
      return this.returning;
   }

   public void setReturning(boolean returning) {
      this.returning = returning;
   }

   public List<SQLTableSource> getUsingList() {
      return this.usingList;
   }

   public void setUsingList(List<SQLTableSource> usingList) {
      this.usingList = usingList;
   }

   public String getAlias() {
      return this.tableSource == null ? null : this.tableSource.getAlias();
   }

   public void setAlias(String alias) {
      this.tableSource.setAlias(alias);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DB2ASTVisitor) {
         this.accept0((DB2ASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public DB2DeleteStatement clone() {
      DB2DeleteStatement x = new DB2DeleteStatement();
      this.cloneTo(x);
      x.returning = this.returning;
      return x;
   }
}
