package com.alibaba.druid.sql.dialect.db2.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObject;
import com.alibaba.druid.sql.dialect.db2.ast.DB2SQLObjectImpl;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DB2AlterTableSetReset extends DB2SQLObjectImpl implements SQLAlterTableItem, DB2SQLObject {
   private boolean set = false;
   private boolean cluster = false;
   private boolean oids = false;
   private List<StorageParameter> parameters = new ArrayList();
   private SQLExpr tablespace;

   public boolean isSet() {
      return this.set;
   }

   public void setSet(boolean set) {
      this.set = set;
   }

   public boolean isCluster() {
      return this.cluster;
   }

   public void setCluster(boolean cluster) {
      this.cluster = cluster;
   }

   public boolean isOids() {
      return this.oids;
   }

   public void setOids(boolean oids) {
      this.oids = oids;
   }

   public List<StorageParameter> getParameters() {
      return this.parameters;
   }

   public void setParameters(List<StorageParameter> parameters) {
      this.parameters = parameters;
   }

   public SQLExpr getTablespace() {
      return this.tablespace;
   }

   public void setTablespace(SQLExpr tablespace) {
      this.tablespace = tablespace;
      tablespace.setParent(this);
   }

   public void addParameter(StorageParameter p) {
      this.parameters.add(p);
      p.setParent(this);
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((DB2ASTVisitor)visitor);
   }

   public void accept0(DB2ASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.parameters);
         this.acceptChild(visitor, this.tablespace);
      }

      visitor.endVisit(this);
   }

   public DB2AlterTableSetReset clone() {
      DB2AlterTableSetReset c = new DB2AlterTableSetReset();
      c.set = this.set;
      c.cluster = this.cluster;
      c.oids = this.oids;

      for(StorageParameter parameter : this.parameters) {
         c.addParameter(parameter.clone());
      }

      if (this.tablespace != null) {
         c.setTablespace(this.tablespace.clone());
      }

      return c;
   }

   public static class StorageParameter extends DB2SQLObjectImpl {
      private SQLExpr parameter;
      private SQLExpr value;

      public SQLExpr getParameter() {
         return this.parameter;
      }

      public void setParameter(SQLExpr parameter) {
         this.parameter = parameter;
         parameter.setParent(this);
      }

      public SQLExpr getValue() {
         return this.value;
      }

      public void setValue(SQLExpr value) {
         this.value = value;
         value.setParent(this);
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((DB2ASTVisitor)visitor);
      }

      public void accept0(DB2ASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.parameter.accept(visitor);
            if (this.value != null) {
               this.value.accept(visitor);
            }
         }

         visitor.endVisit(this);
      }

      public StorageParameter clone() {
         StorageParameter c = new StorageParameter();
         c.setParameter(this.parameter.clone());
         if (this.value != null) {
            c.setValue(this.value.clone());
         }

         return c;
      }
   }
}
