package com.alibaba.druid.sql.dialect.dm.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmAnalytic extends SQLOver implements SQLReplaceable, DMExpr {
   private DmAnalyticWindowing windowing;

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitionBy);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.windowing);
      }

      visitor.endVisit(this);
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.addAll(this.partitionBy);
      if (this.orderBy != null) {
         children.add(this.orderBy);
      }

      if (this.windowing != null) {
         children.add(this.windowing);
      }

      return children;
   }

   public DmAnalyticWindowing getWindowing() {
      return this.windowing;
   }

   public DmAnalytic clone() {
      DmAnalytic x = new DmAnalytic();
      this.cloneTo(x);
      if (this.windowing != null) {
         x.setWindowing(this.windowing.clone());
      }

      return x;
   }

   public void setWindowing(DmAnalyticWindowing x) {
      if (x != null) {
         x.setParent(this);
      }

      this.windowing = x;
   }

   public SQLDataType computeDataType() {
      return null;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = 0; i < this.partitionBy.size(); ++i) {
         if (this.partitionBy.get(i) == expr) {
            this.partitionBy.set(i, target);
            return true;
         }
      }

      return false;
   }
}
