package com.alibaba.druid.sql.dialect.dm.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class DmAnalyticWindowing extends SQLObjectImpl implements DMExpr {
   private Type type;
   private SQLExpr expr;

   protected void accept0(SQLASTVisitor v) {
      if (v instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)v);
      } else {
         if (v instanceof SQLASTOutputVisitor) {
            ((SQLASTOutputVisitor)v).print(this.toString());
         }

      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.expr);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getExpr() {
      return this.expr;
   }

   public void setExpr(SQLExpr expr) {
      if (expr != null) {
         expr.setParent(this);
      }

      this.expr = expr;
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public DmAnalyticWindowing clone() {
      DmAnalyticWindowing x = new DmAnalyticWindowing();
      x.type = this.type;
      if (this.expr != null) {
         x.setExpr(this.expr.clone());
      }

      return x;
   }

   public List<SQLObject> getChildren() {
      return Collections.singletonList(this.expr);
   }

   public static enum Type {
      ROWS,
      RANGE;
   }
}
