package com.alibaba.druid.sql.dialect.dm.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.dm.ast.DMSQLObject;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class DmSelectQueryBlock extends SQLSelectQueryBlock implements DMSQLObject {
   private SQLLimit top;
   private boolean percent;
   private boolean withties;
   protected SQLExpr intoVariable;

   public DmSelectQueryBlock() {
      this.dbType = DbType.dm;
   }

   public DmSelectQueryBlock clone() {
      DmSelectQueryBlock x = new DmSelectQueryBlock();
      this.cloneTo(x);
      return x;
   }

   public int getHintsSize() {
      return this.hints == null ? 0 : this.hints.size();
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            DmSelectQueryBlock that = (DmSelectQueryBlock)o;
            if (this.hints != null) {
               if (!this.hints.equals(that.hints)) {
                  return false;
               }
            } else if (that.hints != null) {
               return false;
            }

            return true;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = super.hashCode();
      result = 31 * result + (this.hints != null ? this.hints.hashCode() : 0);
      return result;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof DmASTVisitor) {
         this.accept0((DmASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.top);
         this.acceptChild(visitor, this.hints);
         this.acceptChild(visitor, this.selectList);
         this.acceptChild(visitor, this.from);
         this.acceptChild(visitor, this.into);
         this.acceptChild(visitor, this.where);
         this.acceptChild(visitor, this.startWith);
         this.acceptChild(visitor, this.connectBy);
         this.acceptChild(visitor, this.groupBy);
         this.acceptChild(visitor, this.windows);
         this.acceptChild(visitor, this.orderBy);
         this.acceptChild(visitor, this.distributeBy);
         this.acceptChild(visitor, this.sortBy);
         this.acceptChild(visitor, this.waitTime);
         this.acceptChild(visitor, this.limit);
         this.acceptChild(visitor, this.forUpdateOf);
      }

      visitor.endVisit(this);
   }

   public void setFirst(SQLExpr first, boolean percent) {
      if (this.limit == null) {
         this.limit = new SQLLimit();
      }

      this.limit.setRowCount(first);
      this.limit.setPercent(percent);
      this.limit.setType(SQLLimit.Type.FETCH);
   }

   public SQLExpr getIntoVariable() {
      return this.intoVariable;
   }

   public void setIntoVariable(SQLExpr intoVariable) {
      this.intoVariable = intoVariable;
   }

   public String toString() {
      return SQLUtils.toDmString(this);
   }

   public SQLLimit getTop() {
      return this.top;
   }

   public void setTop(SQLLimit top) {
      this.top = top;
   }

   public boolean isPercent() {
      return this.percent;
   }

   public void setPercent(boolean percent) {
      this.percent = percent;
   }

   public boolean isWithties() {
      return this.withties;
   }

   public void setWithties(boolean withties) {
      this.withties = withties;
   }
}
