package com.alibaba.druid.sql.dialect.es.ast;

import com.alibaba.druid.sql.dialect.es.visitor.ESOutputVisitor;
import com.alibaba.druid.sql.dialect.es.visitor.Printer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EsParserContextBase extends ParserRuleContext {
   public static final String VERSION = "V7.16";
   private Map<String, Object> attributes;
   public boolean supportRegex = false;
   public List<EsParserContextBase> items;
   public boolean field;
   public boolean value;
   public List<EsParserContextBase> fields;
   public List<EsParserContextBase> values;
   public List<EsParserContextBase> valueBinds;
   public List<EsParserContextBase> indices;
   public List<EsParserContextBase> ids;
   private String text;

   public EsParserContextBase() {
   }

   public EsParserContextBase(ParserRuleContext parent, int invokingStateNumber) {
      super(parent, invokingStateNumber);
   }

   public void putAttribute(String name, Object value) {
      if (this.attributes == null) {
         this.attributes = new HashMap(6);
      }

      this.attributes.put(name, value);
   }

   public Object getAttribute(String name) {
      return this.attributes == null ? null : this.attributes.get(name);
   }

   public boolean existsAttribute(String name) {
      return this.attributes == null ? false : this.attributes.containsKey(name);
   }

   public Map<String, Object> getAttributes() {
      return this.attributes;
   }

   public void addValue(EsParserContextBase value) {
      if (value != null) {
         if (this.values == null) {
            this.values = new ArrayList();
         }

         if (!this.values.contains(value)) {
            this.values.add(value);
         }

      }
   }

   public void addField(EsParserContextBase field) {
      if (field != null) {
         if (this.fields == null) {
            this.fields = new ArrayList();
         }

         if (!this.fields.contains(field)) {
            this.fields.add(field);
         }

      }
   }

   public void addField(EsParserContextBase... field) {
      if (field != null && field.length != 0) {
         for(EsParserContextBase fd : field) {
            this.addField(fd);
         }

      }
   }

   public void addFieldValue(EsParserContextBase field, EsParserContextBase value) {
      this.addField(field);
      this.addValue(value);
   }

   public String getTextValue() {
      if (this.getChildCount() == 0) {
         return "";
      } else {
         StringBuilder builder = new StringBuilder();

         for(int i = 0; i < this.getChildCount(); ++i) {
            builder.append(this.disQuota(this.getChild(i).getText()));
         }

         return builder.toString();
      }
   }

   public String disQuota(String s) {
      if (s.length() >= 6 && s.startsWith("\"\"\"") && s.endsWith("\"\"\"")) {
         return s.length() == 6 ? "" : s.substring(3, s.length() - 3);
      } else if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
         return s.length() == 2 ? "" : s.substring(1, s.length() - 1);
      } else {
         return s;
      }
   }

   public String toString() {
      ESOutputVisitor visitor = new ESOutputVisitor();
      Printer printer = visitor.visit(this);
      return printer.toString();
   }

   public void replace(ParseTree child, ParseTree newChild, boolean addIfNotExists) {
      int index = this.children.indexOf(child);
      if (index == -1 && addIfNotExists) {
         this.children.add(newChild);
      } else {
         this.children.remove(index);
         this.children.add(newChild);
      }
   }

   public String getText() {
      return this.text != null ? this.text : super.getText();
   }
}
