package com.alibaba.druid.sql.dialect.greenplum.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GPAlterSchemaStatement extends SQLStatementImpl implements GPSQLStatement, SQLAlterStatement {
   private SQLIdentifierExpr schemaName;
   private SQLIdentifierExpr newName;
   private SQLIdentifierExpr newOwner;

   public GPAlterSchemaStatement() {
      this.dbType = DbType.greenplum;
   }

   public SQLIdentifierExpr getSchemaName() {
      return this.schemaName;
   }

   public void setSchemaName(SQLIdentifierExpr schemaName) {
      this.schemaName = schemaName;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public SQLIdentifierExpr getNewName() {
      return this.newName;
   }

   public void setNewName(SQLIdentifierExpr newName) {
      this.newName = newName;
   }

   public SQLIdentifierExpr getNewOwner() {
      return this.newOwner;
   }

   public void setNewOwner(SQLIdentifierExpr newOwner) {
      this.newOwner = newOwner;
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schemaName);
         this.acceptChild(visitor, this.newName);
         this.acceptChild(visitor, this.newOwner);
      }

      visitor.endVisit(this);
   }
}
