package com.alibaba.druid.sql.dialect.greenplum.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class GPCreateSchemaStatement extends SQLStatementImpl implements GPSQLStatement, SQLCreateStatement {
   private SQLIdentifierExpr schemaName;
   private SQLIdentifierExpr userName;
   private boolean ifNotExists;
   private boolean authorization;
   private List<SQLStatement> elements = new ArrayList();

   public GPCreateSchemaStatement() {
      this.dbType = DbType.greenplum;
   }

   public SQLIdentifierExpr getSchemaName() {
      return this.schemaName;
   }

   public void addElement(SQLStatement e) {
      e.setParent(this);
      this.elements.add(e);
   }

   public List<SQLStatement> getElements() {
      return this.elements;
   }

   public void setElements(List<SQLStatement> elements) {
      this.elements = elements;
   }

   public void setSchemaName(SQLIdentifierExpr schemaName) {
      this.schemaName = schemaName;
      schemaName.setParent(this);
   }

   public SQLIdentifierExpr getUserName() {
      return this.userName;
   }

   public void setUserName(SQLIdentifierExpr userName) {
      this.userName = userName;
      userName.setParent(this);
   }

   public boolean isIfNotExists() {
      return this.ifNotExists;
   }

   public void setIfNotExists(boolean ifNotExists) {
      this.ifNotExists = ifNotExists;
   }

   public boolean isAuthorization() {
      return this.authorization;
   }

   public void setAuthorization(boolean authorization) {
      this.authorization = authorization;
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schemaName);
         this.acceptChild(visitor, this.userName);
         this.acceptChild(visitor, this.elements);
      }

      visitor.endVisit(this);
   }
}
