package com.alibaba.druid.sql.dialect.greenplum.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObject;
import com.alibaba.druid.sql.dialect.greenplum.ast.GPSQLObjectImpl;
import com.alibaba.druid.sql.dialect.greenplum.visitor.GPASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class GPAlterTableAddConstraint extends GPSQLObjectImpl implements SQLAlterTableItem, GPSQLObject {
   private SQLExpr constraint;
   private GPAlterTableAddConstraintUsingIndex usingIndex;

   public SQLExpr getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLExpr constraint) {
      this.constraint = constraint;
   }

   public GPAlterTableAddConstraintUsingIndex getUsingIndex() {
      return this.usingIndex;
   }

   public void setUsingIndex(GPAlterTableAddConstraintUsingIndex usingIndex) {
      this.usingIndex = usingIndex;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((GPASTVisitor)visitor);
   }

   public void accept0(GPASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.constraint);
         this.acceptChild(visitor, this.usingIndex);
      }

      visitor.endVisit(this);
   }

   public GPAlterTableAddConstraint clone() {
      GPAlterTableAddConstraint c = new GPAlterTableAddConstraint();
      if (this.constraint != null) {
         c.setConstraint(this.constraint.clone());
      }

      if (this.usingIndex != null) {
         c.setUsingIndex(this.usingIndex.clone());
      }

      return c;
   }

   public static class GPAlterTableAddConstraintUsingIndex extends GPSQLObjectImpl {
      private SQLExpr constraint;
      private SQLExpr indexName;
      private ConstraintType type;
      private ConstraintStrategy strategy;

      public SQLExpr getConstraint() {
         return this.constraint;
      }

      public void setConstraint(SQLExpr constraint) {
         this.constraint = constraint;
         constraint.setParent(this);
      }

      public SQLExpr getIndexName() {
         return this.indexName;
      }

      public void setIndexName(SQLExpr indexName) {
         this.indexName = indexName;
         indexName.setParent(this);
      }

      public ConstraintType getType() {
         return this.type;
      }

      public void setType(ConstraintType type) {
         this.type = type;
      }

      public ConstraintStrategy getStrategy() {
         return this.strategy;
      }

      public void setStrategy(ConstraintStrategy strategy) {
         this.strategy = strategy;
      }

      public void accept0(SQLASTVisitor visitor) {
         this.accept0((GPASTVisitor)visitor);
      }

      public void accept0(GPASTVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.constraint);
            this.acceptChild(visitor, this.indexName);
         }

         visitor.endVisit(this);
      }

      public GPAlterTableAddConstraintUsingIndex clone() {
         GPAlterTableAddConstraintUsingIndex c = new GPAlterTableAddConstraintUsingIndex();
         c.setConstraint(this.constraint);
         c.setIndexName(this.indexName);
         c.strategy = this.strategy;
         c.type = this.type;
         return c;
      }

      public static enum ConstraintType {
         unique,
         primaryKey;
      }

      public static enum ConstraintStrategy {
         deferable,
         notDeferable,
         initiallyDefered,
         initiallyImmediate;
      }
   }
}
