package com.alibaba.druid.sql.dialect.kingbase.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.dialect.kingbase.visitor.KingbaseASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public abstract class KingbaseStatementImpl extends SQLStatementImpl implements KingbaseStatement {
   public KingbaseStatementImpl() {
      super(DbType.kingbase);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof KingbaseASTVisitor) {
         this.accept0((KingbaseASTVisitor)((KingbaseASTVisitor)visitor));
      } else {
         throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
      }
   }

   public void accept0(MySqlASTVisitor v) {
      throw new UnsupportedOperationException(this.getClass().getName());
   }

   public List<SQLObject> getChildren() {
      throw new UnsupportedOperationException(this.getClass().getName());
   }
}
