package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;

public class MySqlRenameSequenceStatement extends MySqlStatementImpl implements SQLAlterStatement {
   private SQLName name;
   private SQLName to;

   public void accept0(MySqlASTVisitor v) {
      if (v.visit(this)) {
         if (this.name != null) {
            this.name.accept(v);
         }

         if (this.to != null) {
            this.to.accept(v);
         }
      }

      v.endVisit(this);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.name = x;
   }

   public SQLName getTo() {
      return this.to;
   }

   public void setTo(SQLName x) {
      if (x != null) {
         x.setParent(this);
      }

      this.to = x;
   }
}
