package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlFlushStatement;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import java.util.ArrayList;
import java.util.List;

public class MySqlExportParameterVisitor extends MySqlOutputVisitor implements ExportParameterVisitor {
   private boolean requireParameterizedOutput;

   public MySqlExportParameterVisitor(List<Object> parameters, Appendable appender, boolean wantParameterizedOutput) {
      super(appender, true);
      this.parameters = parameters;
      this.requireParameterizedOutput = wantParameterizedOutput;
   }

   public MySqlExportParameterVisitor() {
      this(new ArrayList());
   }

   public MySqlExportParameterVisitor(List<Object> parameters) {
      this(parameters, (Appendable)null, false);
   }

   public MySqlExportParameterVisitor(Appendable appender) {
      this(new ArrayList(), appender, true);
   }

   public List<Object> getParameters() {
      return this.parameters;
   }

   public boolean visit(SQLSelectItem x) {
      return this.requireParameterizedOutput ? super.visit((SQLSelectItem)x) : true;
   }

   public boolean visit(SQLLimit x) {
      return this.requireParameterizedOutput ? super.visit((SQLLimit)x) : true;
   }

   public boolean visit(SQLOrderBy x) {
      return this.requireParameterizedOutput ? super.visit((SQLOrderBy)x) : false;
   }

   public boolean visit(SQLSelectGroupByClause x) {
      return this.requireParameterizedOutput ? super.visit((SQLSelectGroupByClause)x) : false;
   }

   public boolean visit(SQLMethodInvokeExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLMethodInvokeExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getArguments());
         return true;
      }
   }

   public boolean visit(SQLInListExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLInListExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParamterAndAccept(this.parameters, x.getTargetList());
         return true;
      }
   }

   public boolean visit(SQLBetweenExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLBetweenExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParameter(this.parameters, x);
         return true;
      }
   }

   public boolean visit(SQLBinaryOpExpr x) {
      if (this.requireParameterizedOutput) {
         return super.visit((SQLBinaryOpExpr)x);
      } else {
         ExportParameterVisitorUtils.exportParameter(this.parameters, x);
         return true;
      }
   }

   public boolean visit(MySqlFlushStatement x) {
      return true;
   }

   public void endVisit(MySqlFlushStatement x) {
   }
}
