package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleCheck extends SQLCheck implements OracleConstraint, OracleSQLObject {
   private OracleUsingIndexClause using;
   private SQLName exceptionsInto;
   private Initially initially;
   private Boolean deferrable;

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof OracleASTVisitor) {
         this.accept0((OracleASTVisitor)visitor);
      } else {
         super.accept(visitor);
      }
   }

   public void accept0(OracleASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getName());
         this.acceptChild(visitor, this.getExpr());
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.exceptionsInto);
      }

      visitor.endVisit(this);
   }

   public Boolean getDeferrable() {
      return this.deferrable;
   }

   public void setDeferrable(Boolean deferrable) {
      this.deferrable = deferrable;
   }

   public Initially getInitially() {
      return this.initially;
   }

   public void setInitially(Initially initially) {
      this.initially = initially;
   }

   public SQLName getExceptionsInto() {
      return this.exceptionsInto;
   }

   public void setExceptionsInto(SQLName exceptionsInto) {
      this.exceptionsInto = exceptionsInto;
   }

   public OracleUsingIndexClause getUsing() {
      return this.using;
   }

   public void setUsing(OracleUsingIndexClause using) {
      if (using != null) {
         using.setParent(this);
      }

      this.using = using;
   }

   public void cloneTo(OracleCheck x) {
      super.cloneTo(x);
      if (this.using != null) {
         x.setUsing(this.using.clone());
      }

      if (this.exceptionsInto != null) {
         x.setExceptionsInto(this.exceptionsInto.clone());
      }

      x.initially = this.initially;
      x.deferrable = this.deferrable;
   }

   public OracleCheck clone() {
      OracleCheck x = new OracleCheck();
      this.cloneTo(x);
      return x;
   }
}
