package com.alibaba.druid.sql.dialect.postgresql.ast.stmt;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class PGDeleteStatement extends SQLDeleteStatement implements PGSQLStatement {
   private boolean returning;
   protected List<SQLTableSource> usingList;

   public PGDeleteStatement() {
      super(DbType.postgresql);
   }

   public boolean isReturning() {
      return this.returning;
   }

   public void setReturning(boolean returning) {
      this.returning = returning;
   }

   public List<SQLTableSource> getUsingList() {
      return this.usingList;
   }

   public void setUsingList(List<SQLTableSource> usingList) {
      this.usingList = usingList;
   }

   public String getAlias() {
      return this.tableSource == null ? null : this.tableSource.getAlias();
   }

   public void setAlias(String alias) {
      this.tableSource.setAlias(alias);
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof PGASTVisitor) {
         this.accept0((PGASTVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.using);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public PGDeleteStatement clone() {
      PGDeleteStatement x = new PGDeleteStatement();
      this.cloneTo(x);
      x.returning = this.returning;
      return x;
   }
}
