package com.alibaba.druid.sql.dialect.postgresql.ast.stmt.alterTable;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGSQLObjectImpl;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class PGAlterTableDisableEnabelTrigger extends PGSQLObjectImpl implements SQLAlterTableItem, PGSQLObject {
   private boolean isEnable;
   private SQLExpr trigger;
   private Type type = null;

   public SQLExpr getTrigger() {
      return this.trigger;
   }

   public void setTrigger(SQLExpr trigger) {
      this.trigger = trigger;
      trigger.setParent(this);
   }

   public Type getType() {
      return this.type;
   }

   public void setType(Type type) {
      this.type = type;
   }

   public boolean isEnable() {
      return this.isEnable;
   }

   public void setEnable(boolean enable) {
      this.isEnable = enable;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this) && this.trigger != null) {
         this.trigger.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public PGAlterTableDisableEnabelTrigger clone() {
      PGAlterTableDisableEnabelTrigger c = new PGAlterTableDisableEnabelTrigger();
      c.setTrigger(this.trigger.clone());
      c.type = this.type;
      c.isEnable = this.isEnable;
      return c;
   }

   public static enum Type {
      all,
      user;
   }
}
