package com.alibaba.druid.sql.dialect.spark.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkDefProperty;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class SparkAlterDatabaseStatement extends SparkStatementImpl implements SparkStatement {
   private SQLExpr alterType;
   private SQLExpr name;
   private SQLExpr location;
   private SQLExpr propType;
   private List<SparkDefProperty> props = new ArrayList();

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.alterType);
         this.acceptChild(v, this.name);
         this.acceptChild(v, this.location);
         this.acceptChild(v, this.propType);
         this.acceptChild(v, this.props);
      }

      v.endVisit(this);
   }

   public SQLExpr getLocation() {
      return this.location;
   }

   public void setLocation(SQLExpr location) {
      this.location = location;
   }

   public SQLExpr getAlterType() {
      return this.alterType;
   }

   public void setAlterType(SQLExpr alterType) {
      this.alterType = alterType;
   }

   public SQLExpr getName() {
      return this.name;
   }

   public void setName(SQLExpr name) {
      this.name = name;
   }

   public SQLExpr getPropType() {
      return this.propType;
   }

   public void setPropType(SQLExpr propType) {
      this.propType = propType;
   }

   public List<SparkDefProperty> getProps() {
      return this.props;
   }

   public void setProps(List<SparkDefProperty> props) {
      this.props = props;
   }

   public SQLStatement clone() {
      SparkAlterDatabaseStatement e = new SparkAlterDatabaseStatement();
      e.alterType = this.alterType.clone();
      e.name = this.name.clone();
      if (this.location != null) {
         e.location = this.location.clone();
      }

      if (this.propType != null) {
         e.propType = this.propType.clone();
      }

      for(SparkDefProperty prop : this.props) {
         e.props.add(prop.clone());
      }

      return e;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (!this.objectNullEquals(this, o)) {
         return false;
      } else {
         SparkAlterDatabaseStatement that = (SparkAlterDatabaseStatement)o;
         if (!this.objectEquals(this.alterType, that.alterType)) {
            return false;
         } else if (!this.objectEquals(this.name, that.name)) {
            return false;
         } else if (!this.objectEquals(this.propType, that.propType)) {
            return false;
         } else if (!this.objectEquals(this.location, that.location)) {
            return false;
         } else if (this.props.size() != that.props.size()) {
            return false;
         } else {
            for(int i = 0; i < this.props.size(); ++i) {
               if (!this.objectEquals(this.props.get(i), that.props.get(i))) {
                  return false;
               }
            }

            return true;
         }
      }
   }

   public int hashCode() {
      int hash = this.alterType.hashCode();
      hash = 31 * hash + this.name.hashCode();
      hash = 31 * hash + (this.location == null ? 0 : this.location.hashCode());
      hash = 31 * hash + (this.propType == null ? 0 : this.propType.hashCode());
      hash = 31 * hash + Objects.hashCode(new Object[]{this.props});
      return hash;
   }
}
