package com.alibaba.druid.sql.dialect.sqlserver.ast.stmt;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SQLServerUnionQueryTableSource extends SQLUnionQueryTableSource implements SQLServerObject, SQLServerSelectTableSource {
   protected SQLServerPivotBase pivot;
   protected String pivotAlias;
   protected List<SQLName> columns = new ArrayList();

   public SQLServerUnionQueryTableSource(SQLUnionQuery query) {
      super(query);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getUnion());
         this.acceptChild(visitor, this.pivot);
      }

      visitor.endVisit(this);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         if (!super.equals(o)) {
            return false;
         } else {
            SQLServerUnionQueryTableSource that = (SQLServerUnionQueryTableSource)o;
            return Objects.equals(this.pivot, that.pivot) && Objects.equals(this.pivotAlias, that.pivotAlias) && Objects.equals(this.columns, that.columns);
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(super.hashCode(), this.pivot, this.pivotAlias, this.columns);
   }

   public SQLServerPivotBase getPivot() {
      return this.pivot;
   }

   public void setPivot(SQLServerPivotBase pivot) {
      this.pivot = pivot;
   }

   public String getPivotAlias() {
      return this.pivotAlias;
   }

   public void setPivotAlias(String pivotAlias) {
      this.pivotAlias = pivotAlias;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public void setColumns(List<SQLName> columns) {
      this.columns = columns;
   }
}
