package com.alibaba.druid.sql.parser;

import com.alibaba.druid.FastsqlException;
import java.io.Serializable;

public class ParserException extends FastsqlException implements Serializable {
   private static final long serialVersionUID = 1L;
   private int line;
   private int column;

   public ParserException() {
   }

   public ParserException(String message) {
      super(message);
   }

   public ParserException(String message, Throwable e) {
      super(message, e);
   }

   public ParserException(String message, int line, int column) {
      super(message);
      this.line = line;
      this.column = column;
   }

   public ParserException(Throwable ex, String ksql) {
      super("parse error. detail message is :\n" + ex.getMessage() + "\nsource sql is : \n" + ksql, ex);
   }
}
