package com.alibaba.druid.sql.visitor;

public enum VisitorFeature {
   OutputUCase,
   OutputPrettyFormat,
   OutputParameterized,
   OutputDesensitize,
   OutputUseInsertValueClauseOriginalString,
   OutputSkipSelectListCacheString,
   OutputSkipInsertColumnsString,
   OutputParameterizedQuesUnMergeInList,
   OutputParameterizedQuesUnMergeOr,
   OutputParameterizedQuesUnMergeAnd,
   OutputParameterizedQuesUnMergeValuesList,
   OutputParameterizedUnMergeShardingTable,
   OutputParameterizedZeroReplaceNotUseOriginalSql,
   OutputRegForPresto,
   /** @deprecated */
   OutputKeepParenthesisWhenNotExpr,
   OutputNameQuote,
   OutputDistributedLiteralInCreateTableStmt;

   public final int mask = 1 << this.ordinal();

   public static boolean isEnabled(int features, VisitorFeature feature) {
      return (features & feature.mask) != 0;
   }

   public static int config(int features, VisitorFeature feature, boolean state) {
      if (state) {
         features |= feature.mask;
      } else {
         features &= ~feature.mask;
      }

      return features;
   }

   public static int of(VisitorFeature... features) {
      if (features == null) {
         return 0;
      } else {
         int value = 0;

         for(VisitorFeature feature : features) {
            value |= feature.mask;
         }

         return value;
      }
   }
}
