package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;

public class Ascii implements Function {
   public static final Ascii instance = new Ascii();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() == 0) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param = (SQLExpr)x.getArguments().get(0);
         param.accept(visitor);
         Object paramValue = param.getAttributes().get("eval.value");
         if (paramValue == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else if (paramValue == SQLEvalVisitor.EVAL_VALUE_NULL) {
            return SQLEvalVisitor.EVAL_VALUE_NULL;
         } else {
            String strValue = paramValue.toString();
            if (strValue.length() == 0) {
               return 0;
            } else {
               int ascii = strValue.charAt(0);
               return ascii;
            }
         }
      }
   }
}
