package com.alibaba.druid.wall.spi;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleExportParameterVisitor;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;

public class OracleWallProvider extends WallProvider {
   public static final String DEFAULT_CONFIG_DIR = "META-INF/druid/wall/oracle";

   public OracleWallProvider() {
      this(new WallConfig("META-INF/druid/wall/oracle"));
   }

   public OracleWallProvider(WallConfig config) {
      super(config, DbType.oracle);
   }

   public SQLStatementParser createParser(String sql) {
      return new OracleStatementParser(sql, new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup});
   }

   public WallVisitor createWallVisitor() {
      return new OracleWallVisitor(this);
   }

   public ExportParameterVisitor createExportParameterVisitor() {
      return new OracleExportParameterVisitor();
   }
}
