package com.palacesun.masking.tools.thkms.util.gmhelper;

import java.util.Arrays;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM3Utils {
   private static final String ENCODING = "UTF-8";

   public static String encrypt(String src, String key) throws Exception {
      return ByteUtils.toHexString(getEncryptByKey(src, key));
   }

   private static byte[] getEncryptByKey(String src, String key) throws Exception {
      byte[] srcByte = src.getBytes("UTF-8");
      byte[] keyByte = key.getBytes("UTF-8");
      KeyParameter keyParameter = new KeyParameter(keyByte);
      SM3Digest sm3 = new SM3Digest();
      HMac hMac = new HMac(sm3);
      hMac.init(keyParameter);
      hMac.update(srcByte, 0, srcByte.length);
      byte[] result = new byte[hMac.getMacSize()];
      hMac.doFinal(result, 0);
      return result;
   }

   public static boolean verify(String src, String sm3HexStr) throws Exception {
      byte[] sm3HashCode = ByteUtils.fromHexString(sm3HexStr);
      byte[] newHashCode = getEncryptBySrcByte(src.getBytes("UTF-8"));
      return Arrays.equals(newHashCode, sm3HashCode);
   }

   public static boolean verify(String src, String key, String sm3HexStr) throws Exception {
      byte[] sm3HashCode = ByteUtils.fromHexString(sm3HexStr);
      byte[] newHashCode = getEncryptByKey(src, key);
      return Arrays.equals(newHashCode, sm3HashCode);
   }

   private static byte[] getEncryptBySrcByte(byte[] srcByte) {
      SM3Digest sm3 = new SM3Digest();
      sm3.update(srcByte, 0, srcByte.length);
      byte[] encryptByte = new byte[sm3.getDigestSize()];
      sm3.doFinal(encryptByte, 0);
      return encryptByte;
   }

   public static void main(String[] args) throws Exception {
      String srcStr = "jm_4bd0294a787b0793cdf6c6fb158a4809#jm_993eb7d065caa0acc8c118c40d93b5d3#jm_b47bef632df37a9c5ce743da5ec60c7b#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f#jm_8b93315723e89425ec830fcc7809c05f";
      String key = "ghca";
      String hexStrByKey = encrypt(srcStr, key);
      System.out.println("带密钥加密后的密文：" + hexStrByKey);
      System.out.println("明文(带密钥)与密文校验结果：" + verify(srcStr, key, hexStrByKey));
   }
}
