package util.sqlparse.visitor.es.memo;

import org.antlr.v4.runtime.tree.ParseTree;
import util.sqlparse.visitor.common.Objects;
import util.sqlparse.visitor.common.scope.Scope;

public class IndexMemo extends Reference {
   public Scope scope;

   public IndexMemo() {
   }

   public IndexMemo(ParseTree x) {
      this();
      this.ref = x;
   }

   public String getQualifiedName() {
      return this.name;
   }

   public String getUniqueName() {
      return this.scope.id + ":" + this.getQualifiedName();
   }

   public String toString() {
      return this.name;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         IndexMemo indexMemo = (IndexMemo)o;
         if ((this.ref != null || indexMemo.ref == null) && (indexMemo.ref != null || this.ref == null)) {
            return this.ref != null && !this.ref.equals(indexMemo.ref) ? false : Objects.equals(this.name, indexMemo.name);
         } else {
            return false;
         }
      } else {
         return false;
      }
   }

   public int hashCode() {
      int result = this.ref == null ? 0 : this.ref.hashCode();
      result = 31 * result + this.name.hashCode();
      return result;
   }
}
