package util.sqlparse.visitor.es.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTool {
   static final Pattern PAT_CHECK = Pattern.compile("(\\])|(\\[)|(\\*)|(\\?)|(\\.)|(\\-)|(\\()|(\\))|(\\{)|(\\})|(\\\\)", 8);

   public static List<String> match(String pattern, List<String> lookupTables) {
      if (pattern != null && pattern.length() != 0) {
         if (lookupTables != null && lookupTables.size() != 0) {
            Matcher matcher = PAT_CHECK.matcher(pattern);
            if (!matcher.find()) {
               return Arrays.asList(pattern);
            } else {
               List<String> matches = new ArrayList();

               for(String lookupTable : lookupTables) {
                  boolean match = match(pattern, lookupTable);
                  if (match) {
                     matches.add(lookupTable);
                  }
               }

               return matches;
            }
         } else {
            return lookupTables;
         }
      } else {
         return new ArrayList();
      }
   }

   static boolean match(String pattern, String lookupTable) {
      if (lookupTable != null && lookupTable.length() != 0) {
         Pattern p = Pattern.compile(pattern);
         return p.matcher(lookupTable).find();
      } else {
         return false;
      }
   }

   public static void main(String[] args) {
      String a = "[aaa]";
      a = "-a";
      a = "(dd";
      a = "\\d";
      System.out.println(PAT_CHECK.matcher(a).find());
   }
}
