package util.sqlparse.visitor.mysql.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class TestJdbc {
   public static void main(String[] args) throws Exception {
      testcache();
   }

   private static void test1(Connection connection) throws ClassNotFoundException, SQLException {
      Statement statement = connection.createStatement();
      ResultSet resultSet = statement.executeQuery("select * from test.sys_dept");

      while(resultSet.next()) {
         System.out.println(resultSet.getString(4));
      }

   }

   private static void test2(Connection connection) throws ClassNotFoundException, SQLException {
      Statement statement = connection.createStatement();
      PreparedStatement prestmt = connection.prepareStatement("select * from test.sys_dept limit ?");
      prestmt.setInt(1, 1);
      prestmt.executeQuery();
   }

   private static Connection connection() throws SQLException {
      String url = "jdbc:mariadb://192.168.2.173:3326/test?zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=UTC";
      Connection connection = DriverManager.getConnection(url, "root", "root");
      return connection;
   }

   public static void testcache() throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.173:3306\",\n      \"url\": \"jdbc:mysql://192.168.2.173:3306/ry\",\n      \"username\": \"root\",\n      \"isIgnorecase\":\"0\",\n      \"password\": \"root\",\n      \"dbType\": \"mysql\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.105\",\n      \"redisNodes\": \"192.168.2.81:6379,192.168.2.81:6380,192.168.2.82:6379,192.168.2.82:6380,192.168.2.83:6379,192.168.2.83:6380\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"123456\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": [\"encryption_test2\",\"ghca_static_develop\",\"ghca_static_develop_test\",\"pg_catalog\",\"information_schema\",\"sysaudit\",\"sysmac\",\"sys\",\"sysmac\",]\n    }";
      Class.forName("com.mysql.jdbc.Driver");
      JdbcUtil.initData(content);
      Map<String, String> params = new HashMap();
      params.put("sql", "select d.dept_id, d.parent_id, d.ancestors, d.dept_name, d.order_num, d.leader, d.phone, d.email, d.status,\n\t\t\t(select dept_name from sys_dept where dept_id = d.parent_id) parent_name\n\t\tfrom sys_dept d\n\t\twhere d.dept_id = ? -- appUsername=");
      params.put("dbType", "mysql");
      params.put("schema", "ry");
      params.put("encryption", "1");
      params.put("url", "jdbc:mysql://192.168.2.173:3306/ry");
      params.put("sqlparseCache", "true");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
   }
}
