package com.alibaba.druid.proxy.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;

public class DatabaseMetaDataProxyImpl implements DatabaseMetaData {
   private DatabaseMetaData metaData;

   public DatabaseMetaDataProxyImpl(DatabaseMetaData metaData) {
      this.metaData = metaData;
   }

   public boolean allProceduresAreCallable() throws SQLException {
      return this.metaData.allProceduresAreCallable();
   }

   public boolean allTablesAreSelectable() throws SQLException {
      return this.metaData.allTablesAreSelectable();
   }

   public String getURL() throws SQLException {
      return this.metaData.getURL();
   }

   public String getUserName() throws SQLException {
      return this.metaData.getUserName();
   }

   public boolean isReadOnly() throws SQLException {
      return this.metaData.isReadOnly();
   }

   public boolean nullsAreSortedHigh() throws SQLException {
      return this.metaData.nullsAreSortedHigh();
   }

   public boolean nullsAreSortedLow() throws SQLException {
      return this.metaData.nullsAreSortedLow();
   }

   public boolean nullsAreSortedAtStart() throws SQLException {
      return this.metaData.nullsAreSortedAtStart();
   }

   public boolean nullsAreSortedAtEnd() throws SQLException {
      return this.metaData.nullsAreSortedAtEnd();
   }

   public String getDatabaseProductName() throws SQLException {
      return this.metaData.getDatabaseProductName();
   }

   public String getDatabaseProductVersion() throws SQLException {
      return this.metaData.getDatabaseProductVersion();
   }

   public String getDriverName() throws SQLException {
      return this.metaData.getDriverName();
   }

   public String getDriverVersion() throws SQLException {
      return this.metaData.getDriverVersion();
   }

   public int getDriverMajorVersion() {
      return this.metaData.getDriverMajorVersion();
   }

   public int getDriverMinorVersion() {
      return this.metaData.getDriverMinorVersion();
   }

   public boolean usesLocalFiles() throws SQLException {
      return this.metaData.usesLocalFiles();
   }

   public boolean usesLocalFilePerTable() throws SQLException {
      return this.metaData.usesLocalFilePerTable();
   }

   public boolean supportsMixedCaseIdentifiers() throws SQLException {
      return this.metaData.supportsMixedCaseIdentifiers();
   }

   public boolean storesUpperCaseIdentifiers() throws SQLException {
      return this.metaData.storesUpperCaseIdentifiers();
   }

   public boolean storesLowerCaseIdentifiers() throws SQLException {
      return this.metaData.storesMixedCaseIdentifiers();
   }

   public boolean storesMixedCaseIdentifiers() throws SQLException {
      return this.metaData.supportsMixedCaseIdentifiers();
   }

   public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
      return this.metaData.supportsMixedCaseQuotedIdentifiers();
   }

   public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
      return this.metaData.storesUpperCaseIdentifiers();
   }

   public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
      return this.metaData.storesLowerCaseQuotedIdentifiers();
   }

   public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
      return this.metaData.storesMixedCaseQuotedIdentifiers();
   }

   public String getIdentifierQuoteString() throws SQLException {
      return this.metaData.getIdentifierQuoteString();
   }

   public String getSQLKeywords() throws SQLException {
      return this.metaData.getSQLKeywords();
   }

   public String getNumericFunctions() throws SQLException {
      return this.metaData.getNumericFunctions();
   }

   public String getStringFunctions() throws SQLException {
      return this.metaData.getStringFunctions();
   }

   public String getSystemFunctions() throws SQLException {
      return this.metaData.getSystemFunctions();
   }

   public String getTimeDateFunctions() throws SQLException {
      return this.metaData.getTimeDateFunctions();
   }

   public String getSearchStringEscape() throws SQLException {
      return this.metaData.getSearchStringEscape();
   }

   public String getExtraNameCharacters() throws SQLException {
      return this.metaData.getExtraNameCharacters();
   }

   public boolean supportsAlterTableWithAddColumn() throws SQLException {
      return this.metaData.supportsAlterTableWithAddColumn();
   }

   public boolean supportsAlterTableWithDropColumn() throws SQLException {
      return this.metaData.supportsAlterTableWithDropColumn();
   }

   public boolean supportsColumnAliasing() throws SQLException {
      return this.metaData.supportsColumnAliasing();
   }

   public boolean nullPlusNonNullIsNull() throws SQLException {
      return this.metaData.nullPlusNonNullIsNull();
   }

   public boolean supportsConvert() throws SQLException {
      return this.metaData.supportsConvert();
   }

   public boolean supportsConvert(int fromType, int toType) throws SQLException {
      return this.metaData.supportsConvert(fromType, toType);
   }

   public boolean supportsTableCorrelationNames() throws SQLException {
      return this.metaData.supportsTableCorrelationNames();
   }

   public boolean supportsDifferentTableCorrelationNames() throws SQLException {
      return this.metaData.supportsDifferentTableCorrelationNames();
   }

   public boolean supportsExpressionsInOrderBy() throws SQLException {
      return this.metaData.supportsExpressionsInOrderBy();
   }

   public boolean supportsOrderByUnrelated() throws SQLException {
      return this.metaData.supportsOrderByUnrelated();
   }

   public boolean supportsGroupBy() throws SQLException {
      return this.metaData.supportsGroupBy();
   }

   public boolean supportsGroupByUnrelated() throws SQLException {
      return this.metaData.supportsGroupByUnrelated();
   }

   public boolean supportsGroupByBeyondSelect() throws SQLException {
      return this.metaData.supportsGroupByBeyondSelect();
   }

   public boolean supportsLikeEscapeClause() throws SQLException {
      return this.metaData.supportsLikeEscapeClause();
   }

   public boolean supportsMultipleResultSets() throws SQLException {
      return this.metaData.supportsMultipleResultSets();
   }

   public boolean supportsMultipleTransactions() throws SQLException {
      return this.metaData.supportsMultipleTransactions();
   }

   public boolean supportsNonNullableColumns() throws SQLException {
      return this.metaData.supportsNonNullableColumns();
   }

   public boolean supportsMinimumSQLGrammar() throws SQLException {
      return this.metaData.supportsMinimumSQLGrammar();
   }

   public boolean supportsCoreSQLGrammar() throws SQLException {
      return this.metaData.supportsCoreSQLGrammar();
   }

   public boolean supportsExtendedSQLGrammar() throws SQLException {
      return this.metaData.supportsExtendedSQLGrammar();
   }

   public boolean supportsANSI92EntryLevelSQL() throws SQLException {
      return this.metaData.supportsANSI92EntryLevelSQL();
   }

   public boolean supportsANSI92IntermediateSQL() throws SQLException {
      return this.metaData.supportsANSI92IntermediateSQL();
   }

   public boolean supportsANSI92FullSQL() throws SQLException {
      return this.metaData.supportsANSI92FullSQL();
   }

   public boolean supportsIntegrityEnhancementFacility() throws SQLException {
      return this.metaData.supportsIntegrityEnhancementFacility();
   }

   public boolean supportsOuterJoins() throws SQLException {
      return this.metaData.supportsOuterJoins();
   }

   public boolean supportsFullOuterJoins() throws SQLException {
      return this.metaData.supportsFullOuterJoins();
   }

   public boolean supportsLimitedOuterJoins() throws SQLException {
      return this.metaData.supportsLimitedOuterJoins();
   }

   public String getSchemaTerm() throws SQLException {
      return this.metaData.getSchemaTerm();
   }

   public String getProcedureTerm() throws SQLException {
      return this.metaData.getProcedureTerm();
   }

   public String getCatalogTerm() throws SQLException {
      return this.metaData.getCatalogTerm();
   }

   public boolean isCatalogAtStart() throws SQLException {
      return this.metaData.isCatalogAtStart();
   }

   public String getCatalogSeparator() throws SQLException {
      return this.metaData.getCatalogSeparator();
   }

   public boolean supportsSchemasInDataManipulation() throws SQLException {
      return this.metaData.supportsSchemasInDataManipulation();
   }

   public boolean supportsSchemasInProcedureCalls() throws SQLException {
      return this.metaData.supportsSchemasInProcedureCalls();
   }

   public boolean supportsSchemasInTableDefinitions() throws SQLException {
      return this.metaData.supportsSchemasInTableDefinitions();
   }

   public boolean supportsSchemasInIndexDefinitions() throws SQLException {
      return this.metaData.supportsSchemasInIndexDefinitions();
   }

   public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
      return this.metaData.supportsSchemasInPrivilegeDefinitions();
   }

   public boolean supportsCatalogsInDataManipulation() throws SQLException {
      return this.metaData.supportsCatalogsInDataManipulation();
   }

   public boolean supportsCatalogsInProcedureCalls() throws SQLException {
      return this.metaData.supportsCatalogsInProcedureCalls();
   }

   public boolean supportsCatalogsInTableDefinitions() throws SQLException {
      return this.metaData.supportsCatalogsInTableDefinitions();
   }

   public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
      return this.metaData.supportsCatalogsInIndexDefinitions();
   }

   public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
      return this.metaData.supportsCatalogsInPrivilegeDefinitions();
   }

   public boolean supportsPositionedDelete() throws SQLException {
      return this.metaData.supportsPositionedDelete();
   }

   public boolean supportsPositionedUpdate() throws SQLException {
      return this.metaData.supportsPositionedUpdate();
   }

   public boolean supportsSelectForUpdate() throws SQLException {
      return this.metaData.supportsSelectForUpdate();
   }

   public boolean supportsStoredProcedures() throws SQLException {
      return this.metaData.supportsStoredProcedures();
   }

   public boolean supportsSubqueriesInComparisons() throws SQLException {
      return this.metaData.supportsSubqueriesInComparisons();
   }

   public boolean supportsSubqueriesInExists() throws SQLException {
      return this.metaData.supportsSubqueriesInExists();
   }

   public boolean supportsSubqueriesInIns() throws SQLException {
      return this.metaData.supportsSubqueriesInIns();
   }

   public boolean supportsSubqueriesInQuantifieds() throws SQLException {
      return this.metaData.supportsSubqueriesInQuantifieds();
   }

   public boolean supportsCorrelatedSubqueries() throws SQLException {
      return this.metaData.supportsCorrelatedSubqueries();
   }

   public boolean supportsUnion() throws SQLException {
      return this.metaData.supportsUnion();
   }

   public boolean supportsUnionAll() throws SQLException {
      return this.metaData.supportsUnionAll();
   }

   public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
      return this.metaData.supportsOpenCursorsAcrossCommit();
   }

   public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
      return this.metaData.supportsOpenCursorsAcrossRollback();
   }

   public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
      return this.metaData.supportsOpenStatementsAcrossCommit();
   }

   public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
      return this.metaData.supportsOpenStatementsAcrossRollback();
   }

   public int getMaxBinaryLiteralLength() throws SQLException {
      return this.metaData.getMaxBinaryLiteralLength();
   }

   public int getMaxCharLiteralLength() throws SQLException {
      return this.metaData.getMaxCharLiteralLength();
   }

   public int getMaxColumnNameLength() throws SQLException {
      return this.metaData.getMaxColumnNameLength();
   }

   public int getMaxColumnsInGroupBy() throws SQLException {
      return this.metaData.getMaxColumnsInGroupBy();
   }

   public int getMaxColumnsInIndex() throws SQLException {
      return this.metaData.getMaxColumnsInIndex();
   }

   public int getMaxColumnsInOrderBy() throws SQLException {
      return this.metaData.getMaxColumnsInOrderBy();
   }

   public int getMaxColumnsInSelect() throws SQLException {
      return this.metaData.getMaxColumnsInSelect();
   }

   public int getMaxColumnsInTable() throws SQLException {
      return this.metaData.getMaxColumnsInTable();
   }

   public int getMaxConnections() throws SQLException {
      return this.metaData.getMaxConnections();
   }

   public int getMaxCursorNameLength() throws SQLException {
      return this.metaData.getMaxCursorNameLength();
   }

   public int getMaxIndexLength() throws SQLException {
      return this.metaData.getMaxIndexLength();
   }

   public int getMaxSchemaNameLength() throws SQLException {
      return this.metaData.getMaxSchemaNameLength();
   }

   public int getMaxProcedureNameLength() throws SQLException {
      return this.metaData.getMaxProcedureNameLength();
   }

   public int getMaxCatalogNameLength() throws SQLException {
      return this.metaData.getMaxCatalogNameLength();
   }

   public int getMaxRowSize() throws SQLException {
      return this.metaData.getMaxRowSize();
   }

   public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
      return this.metaData.doesMaxRowSizeIncludeBlobs();
   }

   public int getMaxStatementLength() throws SQLException {
      return this.metaData.getMaxStatementLength();
   }

   public int getMaxStatements() throws SQLException {
      return this.metaData.getMaxStatements();
   }

   public int getMaxTableNameLength() throws SQLException {
      return this.metaData.getMaxTableNameLength();
   }

   public int getMaxTablesInSelect() throws SQLException {
      return this.metaData.getMaxTablesInSelect();
   }

   public int getMaxUserNameLength() throws SQLException {
      return this.metaData.getMaxUserNameLength();
   }

   public int getDefaultTransactionIsolation() throws SQLException {
      return this.metaData.getDefaultTransactionIsolation();
   }

   public boolean supportsTransactions() throws SQLException {
      return this.metaData.supportsTransactions();
   }

   public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
      return this.metaData.supportsTransactionIsolationLevel(level);
   }

   public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
      return this.metaData.supportsDataDefinitionAndDataManipulationTransactions();
   }

   public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
      return this.metaData.supportsDataManipulationTransactionsOnly();
   }

   public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
      return this.metaData.dataDefinitionCausesTransactionCommit();
   }

   public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
      return this.metaData.dataDefinitionIgnoredInTransactions();
   }

   public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
      return this.metaData.getProcedures(catalog, schemaPattern, procedureNamePattern);
   }

   public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
      return this.metaData.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
   }

   public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
      return this.metaData.getTables(catalog, schemaPattern, tableNamePattern, types);
   }

   public ResultSet getSchemas() throws SQLException {
      return this.metaData.getSchemas();
   }

   public ResultSet getCatalogs() throws SQLException {
      return this.metaData.getCatalogs();
   }

   public ResultSet getTableTypes() throws SQLException {
      return this.metaData.getTableTypes();
   }

   public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
      return this.metaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
   }

   public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
      return this.metaData.getColumnPrivileges(catalog, schema, table, columnNamePattern);
   }

   public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
      return this.metaData.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
   }

   public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
      return this.metaData.getBestRowIdentifier(catalog, schema, table, scope, nullable);
   }

   public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
      return this.metaData.getVersionColumns(catalog, schema, table);
   }

   public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
      return this.metaData.getPrimaryKeys(catalog, schema, table);
   }

   public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
      return this.metaData.getImportedKeys(catalog, schema, table);
   }

   public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
      return this.metaData.getExportedKeys(catalog, schema, table);
   }

   public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
      return this.metaData.getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
   }

   public ResultSet getTypeInfo() throws SQLException {
      return this.metaData.getTypeInfo();
   }

   public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
      return this.metaData.getIndexInfo(catalog, schema, table, unique, approximate);
   }

   public boolean supportsResultSetType(int type) throws SQLException {
      return this.metaData.supportsResultSetType(type);
   }

   public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
      return this.metaData.supportsResultSetConcurrency(type, concurrency);
   }

   public boolean ownUpdatesAreVisible(int type) throws SQLException {
      return this.metaData.ownUpdatesAreVisible(type);
   }

   public boolean ownDeletesAreVisible(int type) throws SQLException {
      return this.metaData.ownDeletesAreVisible(type);
   }

   public boolean ownInsertsAreVisible(int type) throws SQLException {
      return this.metaData.ownInsertsAreVisible(type);
   }

   public boolean othersUpdatesAreVisible(int type) throws SQLException {
      return this.metaData.othersUpdatesAreVisible(type);
   }

   public boolean othersDeletesAreVisible(int type) throws SQLException {
      return this.metaData.othersDeletesAreVisible(type);
   }

   public boolean othersInsertsAreVisible(int type) throws SQLException {
      return this.metaData.othersInsertsAreVisible(type);
   }

   public boolean updatesAreDetected(int type) throws SQLException {
      return this.metaData.updatesAreDetected(type);
   }

   public boolean deletesAreDetected(int type) throws SQLException {
      return this.metaData.deletesAreDetected(type);
   }

   public boolean insertsAreDetected(int type) throws SQLException {
      return this.metaData.insertsAreDetected(type);
   }

   public boolean supportsBatchUpdates() throws SQLException {
      return this.metaData.supportsBatchUpdates();
   }

   public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
      return this.metaData.getUDTs(catalog, schemaPattern, typeNamePattern, types);
   }

   public Connection getConnection() throws SQLException {
      return this.metaData.getConnection();
   }

   public boolean supportsSavepoints() throws SQLException {
      return this.metaData.supportsSavepoints();
   }

   public boolean supportsNamedParameters() throws SQLException {
      return this.metaData.supportsNamedParameters();
   }

   public boolean supportsMultipleOpenResults() throws SQLException {
      return this.metaData.supportsMultipleOpenResults();
   }

   public boolean supportsGetGeneratedKeys() throws SQLException {
      return this.metaData.supportsGetGeneratedKeys();
   }

   public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
      return this.metaData.getSuperTypes(catalog, schemaPattern, typeNamePattern);
   }

   public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
      return this.metaData.getSuperTypes(catalog, schemaPattern, tableNamePattern);
   }

   public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
      return this.metaData.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
   }

   public boolean supportsResultSetHoldability(int holdability) throws SQLException {
      return this.metaData.supportsResultSetHoldability(holdability);
   }

   public int getResultSetHoldability() throws SQLException {
      return this.metaData.getResultSetHoldability();
   }

   public int getDatabaseMajorVersion() throws SQLException {
      return this.metaData.getDatabaseMajorVersion();
   }

   public int getDatabaseMinorVersion() throws SQLException {
      return this.metaData.getDatabaseMinorVersion();
   }

   public int getJDBCMajorVersion() throws SQLException {
      return this.metaData.getJDBCMajorVersion();
   }

   public int getJDBCMinorVersion() throws SQLException {
      return this.metaData.getJDBCMinorVersion();
   }

   public int getSQLStateType() throws SQLException {
      return this.metaData.getSQLStateType();
   }

   public boolean locatorsUpdateCopy() throws SQLException {
      return this.metaData.locatorsUpdateCopy();
   }

   public boolean supportsStatementPooling() throws SQLException {
      return this.metaData.supportsStatementPooling();
   }

   public RowIdLifetime getRowIdLifetime() throws SQLException {
      return this.metaData.getRowIdLifetime();
   }

   public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
      return this.metaData.getSchemas(catalog, schemaPattern);
   }

   public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
      return this.metaData.supportsStoredFunctionsUsingCallSyntax();
   }

   public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
      return this.metaData.autoCommitFailureClosesAllResultSets();
   }

   public ResultSet getClientInfoProperties() throws SQLException {
      return this.metaData.getClientInfoProperties();
   }

   public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
      return this.metaData.getFunctions(catalog, schemaPattern, functionNamePattern);
   }

   public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
      return this.metaData.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
   }

   public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
      return null;
   }

   public boolean generatedKeyAlwaysReturned() throws SQLException {
      return true;
   }

   public <T> T unwrap(Class<T> iface) throws SQLException {
      return (T)this.metaData.unwrap(iface);
   }

   public boolean isWrapperFor(Class<?> iface) throws SQLException {
      return this.metaData.isWrapperFor(iface);
   }
}
