package com.alibaba.druid.sql.ast;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SQLRowDataType extends SQLObjectImpl implements SQLDataType {
   private DbType dbType;
   private List<SQLStructDataType.Field> fields = new ArrayList();

   public SQLRowDataType() {
   }

   public SQLRowDataType(DbType dbType) {
      this.dbType = dbType;
   }

   public String getName() {
      return "ROW";
   }

   public long nameHashCode64() {
      return FnvHash.Constants.ROW;
   }

   public void setName(String name) {
      throw new UnsupportedOperationException();
   }

   public List<SQLExpr> getArguments() {
      return Collections.emptyList();
   }

   public Boolean getWithTimeZone() {
      return null;
   }

   public void setWithTimeZone(Boolean value) {
      throw new UnsupportedOperationException();
   }

   public boolean isWithLocalTimeZone() {
      return false;
   }

   public void setWithLocalTimeZone(boolean value) {
      throw new UnsupportedOperationException();
   }

   public void setDbType(DbType dbType) {
      this.dbType = dbType;
   }

   public DbType getDbType() {
      return this.dbType;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.fields);
      }

      visitor.endVisit(this);
   }

   public SQLRowDataType clone() {
      SQLRowDataType x = new SQLRowDataType(this.dbType);

      for(SQLStructDataType.Field field : this.fields) {
         x.addField(field.getName(), field.getDataType().clone());
      }

      return x;
   }

   public List<SQLStructDataType.Field> getFields() {
      return this.fields;
   }

   public SQLStructDataType.Field addField(SQLName name, SQLDataType dataType) {
      SQLStructDataType.Field field = new SQLStructDataType.Field(name, dataType);
      field.setParent(this);
      this.fields.add(field);
      return field;
   }

   public int jdbcType() {
      return 2002;
   }

   public boolean isInt() {
      return false;
   }

   public boolean isNumberic() {
      return false;
   }

   public boolean isString() {
      return false;
   }

   public boolean hasKeyLength() {
      return false;
   }
}
