package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLPartitionSpec;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAlterTableMergePartition extends SQLObjectImpl implements SQLAlterTableItem {
   private final List<SQLPartitionSpec> partitions = new ArrayList(4);
   private boolean ifExists = false;
   private SQLPartitionSpec overwritePartition;

   public List<SQLPartitionSpec> getPartitions() {
      return this.partitions;
   }

   public void addPartition(SQLPartitionSpec x) {
      if (x != null) {
         x.setParent(this);
      }

      this.partitions.add(x);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.partitions);
      }

      visitor.endVisit(this);
   }

   public SQLPartitionSpec getOverwritePartition() {
      return this.overwritePartition;
   }

   public void setOverwritePartition(SQLPartitionSpec x) {
      if (x != null) {
         x.setParent(this);
      }

      this.overwritePartition = x;
   }
}
