package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLCopyFromStatement extends SQLStatementImpl {
   private SQLExprTableSource table;
   private final List<SQLName> columns = new ArrayList();
   private SQLExpr from;
   private SQLExpr accessKeyId;
   private SQLExpr accessKeySecret;
   private final List<SQLAssignItem> options = new ArrayList();
   private final List<SQLAssignItem> partitions = new ArrayList();

   protected void accept0(SQLASTVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.table);
         this.acceptChild(v, this.columns);
         this.acceptChild(v, this.partitions);
         this.acceptChild(v, this.from);
         this.acceptChild(v, this.options);
      }

      v.endVisit(this);
   }

   public SQLExprTableSource getTable() {
      return this.table;
   }

   public void setTable(SQLExprTableSource x) {
      if (x != null) {
         x.setParent(this);
      }

      this.table = x;
   }

   public List<SQLName> getColumns() {
      return this.columns;
   }

   public SQLExpr getFrom() {
      return this.from;
   }

   public void setFrom(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.from = x;
   }

   public SQLExpr getAccessKeyId() {
      return this.accessKeyId;
   }

   public void setAccessKeyId(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.accessKeyId = x;
   }

   public SQLExpr getAccessKeySecret() {
      return this.accessKeySecret;
   }

   public void setAccessKeySecret(SQLExpr x) {
      if (x != null) {
         x.setParent(this);
      }

      this.accessKeySecret = x;
   }

   public List<SQLAssignItem> getOptions() {
      return this.options;
   }

   public List<SQLAssignItem> getPartitions() {
      return this.partitions;
   }
}
