package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;

public class SQLDB2TimeIntervalDataType extends SQLDataTypeImpl {
   private String intervalTime;
   private String toTime;
   private boolean to;

   public SQLDB2TimeIntervalDataType(String name) {
      super(name);
   }

   public String getIntervalTime() {
      return this.intervalTime;
   }

   public void setIntervalTime(String intervalTime) {
      this.intervalTime = intervalTime;
   }

   public String getToTime() {
      return this.toTime;
   }

   public void setToTime(String toTime) {
      this.toTime = toTime;
   }

   public boolean isTo() {
      return this.to;
   }

   public void setTo(boolean to) {
      this.to = to;
   }

   public int getLength() {
      if (this.arguments.size() == 1) {
         SQLExpr arg = (SQLExpr)this.arguments.get(0);
         if (arg instanceof SQLIntegerExpr) {
            return ((SQLIntegerExpr)arg).getNumber().intValue();
         }
      }

      return -1;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor.visit((SQLDataType)this)) {
         for(int i = 0; i < this.arguments.size(); ++i) {
            SQLExpr arg = (SQLExpr)this.arguments.get(i);
            if (arg != null) {
               arg.accept(visitor);
            }
         }
      }

      visitor.endVisit((SQLDataType)this);
   }

   public String toString() {
      return SQLUtils.toSQLString(this);
   }

   public int jdbcType() {
      long nameNash = this.nameHashCode64();
      if (nameNash == FnvHash.Constants.NCHAR) {
         return -15;
      } else if (nameNash != FnvHash.Constants.CHAR && nameNash != FnvHash.Constants.JSON) {
         if (nameNash != FnvHash.Constants.VARCHAR && nameNash != FnvHash.Constants.VARCHAR2 && nameNash != FnvHash.Constants.STRING) {
            return nameNash != FnvHash.Constants.NVARCHAR && nameNash != FnvHash.Constants.NVARCHAR2 ? 1111 : -9;
         } else {
            return 12;
         }
      } else {
         return 1;
      }
   }
}
