package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLLoopStatement extends SQLStatementImpl {
   private String labelName;
   private final List<SQLStatement> statements = new ArrayList();

   public void accept0(SQLASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.statements);
      }

      visitor.endVisit(this);
   }

   public List<SQLStatement> getStatements() {
      return this.statements;
   }

   public String getLabelName() {
      return this.labelName;
   }

   public void setLabelName(String labelName) {
      this.labelName = labelName;
   }

   public void addStatement(SQLStatement stmt) {
      if (stmt != null) {
         stmt.setParent(this);
      }

      this.statements.add(stmt);
   }

   public List getChildren() {
      return this.statements;
   }

   public SQLLoopStatement clone() {
      SQLLoopStatement x = new SQLLoopStatement();
      x.setLabelName(this.labelName);
      x.setAfterSemi(this.afterSemi);
      x.setDbType(this.dbType);

      for(SQLStatement item : this.statements) {
         SQLStatement item2 = item.clone();
         item2.setParent(x);
         x.statements.add(item2);
      }

      if (this.headHints != null) {
         List<SQLCommentHint> headHintsClone = new ArrayList(this.headHints.size());

         for(SQLCommentHint hint : this.headHints) {
            SQLCommentHint h2 = hint.clone();
            h2.setParent(x);
            headHintsClone.add(h2);
         }

         x.setHeadHints(headHintsClone);
      }

      return x;
   }
}
