package com.alibaba.druid.sql.builder;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;

public class SQLFunctionBuilder {
   private final DbType dbType;
   public static final SQLFunctionBuilder Oracle;

   public SQLFunctionBuilder(DbType dbType) {
      this.dbType = dbType;
   }

   public SQLMethodInvokeExpr length(SQLExpr expr) {
      return new SQLMethodInvokeExpr("length", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr lower(SQLExpr expr) {
      return new SQLMethodInvokeExpr("lower", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr upper(SQLExpr expr) {
      return new SQLMethodInvokeExpr("upper", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr substr(SQLExpr expr) {
      return new SQLMethodInvokeExpr("substr", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr ltrim(SQLExpr expr) {
      return new SQLMethodInvokeExpr("ltrim", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr rtrim(SQLExpr expr) {
      return new SQLMethodInvokeExpr("rtrim", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr trim(SQLExpr expr) {
      return new SQLMethodInvokeExpr("trim", (SQLExpr)null, new SQLExpr[]{expr});
   }

   public SQLMethodInvokeExpr ifnull(SQLExpr expr1, SQLExpr expr2) {
      switch (this.dbType) {
         case ads:
         case presto:
         case odps:
            return new SQLMethodInvokeExpr("coalesce", (SQLExpr)null, new SQLExpr[]{expr1, expr2});
         case oracle:
            return new SQLMethodInvokeExpr("nvl", (SQLExpr)null, new SQLExpr[]{expr1, expr2});
         case sqlserver:
            return new SQLMethodInvokeExpr("isnull", (SQLExpr)null, new SQLExpr[]{expr1, expr2});
         default:
            return new SQLMethodInvokeExpr("ifnull", (SQLExpr)null, new SQLExpr[]{expr1, expr2});
      }
   }

   static {
      Oracle = new SQLFunctionBuilder(DbType.oracle);
   }
}
