package com.alibaba.druid.sql.dialect.dm.ast.clause;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.dialect.dm.ast.DmSQLObjectImpl;
import com.alibaba.druid.sql.dialect.dm.visitor.DmASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class DmReturningClause extends DmSQLObjectImpl implements SQLReplaceable {
   private List<SQLExpr> items = new ArrayList();
   private List<SQLExpr> values = new ArrayList();
   private ReturnType returnType;
   private IntoType intoType;

   public List<SQLExpr> getItems() {
      return this.items;
   }

   public void addItem(SQLExpr item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public List<SQLExpr> getValues() {
      return this.values;
   }

   public void addValue(SQLExpr value) {
      if (value != null) {
         value.setParent(this);
      }

      this.values.add(value);
   }

   public void accept0(DmASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.values);
      }

      visitor.endVisit(this);
   }

   public DmReturningClause clone() {
      DmReturningClause x = new DmReturningClause();

      for(SQLExpr item : this.items) {
         SQLExpr item2 = item.clone();
         item2.setParent(x);
         x.items.add(item2);
      }

      for(SQLExpr v : this.values) {
         SQLExpr v2 = v.clone();
         v2.setParent(x);
         x.values.add(v2);
      }

      return x;
   }

   public boolean replace(SQLExpr expr, SQLExpr target) {
      for(int i = this.items.size() - 1; i >= 0; --i) {
         if (this.items.get(i) == expr) {
            target.setParent(this);
            this.items.set(i, target);
            return true;
         }
      }

      for(int i = this.values.size() - 1; i >= 0; --i) {
         if (this.values.get(i) == expr) {
            target.setParent(this);
            this.values.set(i, target);
            return true;
         }
      }

      return false;
   }

   public ReturnType getReturnType() {
      return this.returnType;
   }

   public void setReturnType(ReturnType returnType) {
      this.returnType = returnType;
   }

   public IntoType getIntoType() {
      return this.intoType;
   }

   public void setIntoType(IntoType intoType) {
      this.intoType = intoType;
   }

   public static enum ReturnType {
      RETURN("RETURN"),
      RETURNING("RETURNING");

      public final String name;

      private ReturnType(String name) {
         this.name = name;
      }
   }

   public static enum IntoType {
      INTO("INTO"),
      BULKCOLLECTINTO("BULK COLLECT INTO");

      public final String name;

      private IntoType(String name) {
         this.name = name;
      }
   }
}
