package com.alibaba.druid.sql.dialect.es.visitor;

import com.alibaba.druid.sql.dialect.es.ast.EsParser;
import com.alibaba.druid.sql.dialect.es.ast.EsParserBaseVisitor;
import com.alibaba.druid.sql.dialect.es.ast.EsParserContextBase;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ESOutputVisitor extends EsParserBaseVisitor<Printer> {
   private Printer output;

   public ESOutputVisitor() {
      this.output = new StringBuilderPrinter();
   }

   public ESOutputVisitor(Printer output) {
      this.output = output;
   }

   Printer slash() {
      return this.output.append('/');
   }

   public Printer visitStatement(EsParser.StatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitOtherStatement(EsParser.OtherStatementContext ctx) {
      this.output.append(ctx.httpMethod.getText());
      this.slash();
      this.visitObjectRuleContextList(ctx.uriSeg(), "/");
      this.visit(ctx.uriFragments());
      this.line();
      return this.visit(ctx.obj());
   }

   public Printer visitCreateIndexStatement(EsParser.CreateIndexStatementContext ctx) {
      this.output.append(ctx.httpMethod.getText());
      this.slash();
      this.visit(ctx.indexName);
      this.visit(ctx.uriFragments());
      this.line();
      return this.visit(ctx.createIndexStatementBody());
   }

   public Printer visitCreateIndexStatementBody(EsParser.CreateIndexStatementBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.createIndexStatementMappings(), ctx.createIndexStatementAliases(), ctx.createIndexStatementSettings());
      return this.rparen();
   }

   public Printer visitCreateIndexStatementMappings(EsParser.CreateIndexStatementMappingsContext ctx) {
      this.visit(ctx.MAPPINGS2());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.createIndexStatementMappingsType());
      return this.rparen();
   }

   public Printer visitCreateIndexStatementMappingsType(EsParser.CreateIndexStatementMappingsTypeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUpdateIndexStatement(EsParser.UpdateIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUpdateMappingStatementBody(EsParser.UpdateMappingStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDeleteIndexStatement(EsParser.DeleteIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCloseIndexStatement(EsParser.CloseIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitOpenIndexStatement(EsParser.OpenIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitShrinkIndexStatement(EsParser.ShrinkIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCloneIndexStatement(EsParser.CloneIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRolloverIndexStatement(EsParser.RolloverIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUnfreezeIndexStatement(EsParser.UnfreezeIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFreezeIndexStatement(EsParser.FreezeIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitResloveIndexStatement(EsParser.ResloveIndexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataRenderStatement(EsParser.QueryDataRenderStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataSearchShardsStatement(EsParser.QueryDataSearchShardsStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDdlMappingProperties(EsParser.DdlMappingPropertiesContext ctx) {
      return this.visitObjectRuleContextList(ctx.ddlMappingPropertiesDefine(), ctx.ddlMappingPropertiesDynamic(), ctx.ddlMappingPropertiesDynamicTemplates(), ctx.createIndexStatementMeta(), ctx.ddlMappingPropertiesAll());
   }

   public Printer visitDdlMappingPropertiesDefine(EsParser.DdlMappingPropertiesDefineContext ctx) {
      this.visit(ctx.PROPERTIES());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.ddlFieldDecl());
      return this.rparen();
   }

   public Printer visitDdlFieldDecl(EsParser.DdlFieldDeclContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDdlField(EsParser.DdlFieldContext ctx) {
      return this.visitObjectRuleContextList(ctx.ddlFieldType(), ctx.ddlMappingPropertiesDefine(), ctx.pairs());
   }

   public Printer visitDdlFieldType(EsParser.DdlFieldTypeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQuerySchemaStatement(EsParser.QuerySchemaStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQuerySchemaStatementALL(EsParser.QuerySchemaStatementALLContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQuerySchemaStatementIndex(EsParser.QuerySchemaStatementIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBulkStatement(EsParser.BulkStatementContext ctx) {
      this.visit(ctx.PUT());
      this.visit(ctx.POST());
      EsParser.UriSegIndexContext indexName = ctx.indexName;
      if (indexName != null) {
         this.slash();
         this.visit(indexName);
         this.slash();
      }

      this.visit(ctx.BULK());
      this.slash();
      this.visit(ctx.uriFragments());
      this.visitObjectRuleContextList(ctx.bulkStatementBody(), "\n");
      return this.line();
   }

   public Printer visitBulkStatementBody(EsParser.BulkStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBulkStatementCreate(EsParser.BulkStatementCreateContext ctx) {
      this.lparen();
      this.visit(ctx.CREATE1());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.bulkStatementIndexPart(), ctx.bulkStatementIdPart(), ctx.pairs());
      this.rparen();
      return this.rparen();
   }

   public Printer visitBulkStatementDelete(EsParser.BulkStatementDeleteContext ctx) {
      this.lparen();
      this.visit(ctx.DELETE1());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.bulkStatementIndexPart(), ctx.bulkStatementIdPart(), ctx.pairs());
      this.rparen();
      return this.rparen();
   }

   public Printer visitBulkStatementIndex(EsParser.BulkStatementIndexContext ctx) {
      this.lparen();
      this.visit(ctx.INDEX());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.bulkStatementIndexPart(), ctx.bulkStatementIdPart(), ctx.pairs());
      this.rparen();
      return this.rparen();
   }

   public Printer visitBulkStatementUpdate(EsParser.BulkStatementUpdateContext ctx) {
      this.lparen();
      this.visit(ctx.UPDATE1());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.bulkStatementIndexPart(), ctx.bulkStatementIdPart(), ctx.pairs());
      this.rparen();
      return this.rparen();
   }

   public Printer visitBulkStatementDoc(EsParser.BulkStatementDocContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.bulkStatementDocItem(), ctx.bulkStatementDocItemSource());
      return this.rparen();
   }

   public Printer visitBulkStatementDocItemSource(EsParser.BulkStatementDocItemSourceContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBulkStatementDocItem(EsParser.BulkStatementDocItemContext ctx) {
      this.visit(ctx.DOC());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.bulkStatementDocItemField(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitBulkStatementDocItemField(EsParser.BulkStatementDocItemFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBulkStatementFields(EsParser.BulkStatementFieldsContext ctx) {
      return this.visitObjectRuleContextList(ctx.obj());
   }

   public Printer visitBulkStatementScript(EsParser.BulkStatementScriptContext ctx) {
      this.lparen();
      List<EsParser.JvalueContext> jvalue = ctx.jvalue();
      if (jvalue != null && jvalue.size() > 0) {
         this.visit(ctx.SCRIPT(0));
         this.colon();
         this.visit(ctx.jvalue(0));
      }

      List<EsParser.PairsContext> pairs = ctx.pairs();
      if (pairs != null && pairs.size() > 0) {
         if (jvalue != null && jvalue.size() > 0) {
            this.comma();
         }

         this.visitObjectRuleContextList(pairs);
      }

      return this.rparen();
   }

   public Printer visitBulkStatementIndexPart(EsParser.BulkStatementIndexPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBulkStatementIdPart(EsParser.BulkStatementIdPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatement(EsParser.QueryDataStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementById(EsParser.QueryDataStatementByIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGET(EsParser.QueryDataStatementMGETContext ctx) {
      return this.visitHttp(ctx, EsParser.QueryDataStatementMGETBodyContext.class);
   }

   public Printer visitQueryDataStatementMGETBody(EsParser.QueryDataStatementMGETBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementMGETDocs(), ctx.queryDataStatementMGETIds());
      return this.rparen();
   }

   public Printer visitQueryDataStatementMGETDocs(EsParser.QueryDataStatementMGETDocsContext ctx) {
      this.visit(ctx.DOCS());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.queryDataStatementMGETDoc());
      return this.rsquare();
   }

   public Printer visitQueryDataStatementMGETDoc(EsParser.QueryDataStatementMGETDocContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementMGETDocSource(), ctx.queryDataStatementMGETStoredFields(), ctx.queryDataStatementMGETDocIndex(), ctx.queryDataStatementMGETDocType(), ctx.queryDataStatementMGETDocId(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementMGETDocId(EsParser.QueryDataStatementMGETDocIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocIndex(EsParser.QueryDataStatementMGETDocIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocType(EsParser.QueryDataStatementMGETDocTypeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocSource(EsParser.QueryDataStatementMGETDocSourceContext ctx) {
      this.visit(ctx.SOURCE1());
      this.colon();
      this.visitObjectRuleContextList(ctx.queryDataStatementMGETDocSourceBoolean(), ctx.queryDataStatementMGETDocSourceObj(), ctx.queryDataStatementMGETDocSourceArr());
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocSourceBoolean(EsParser.QueryDataStatementMGETDocSourceBooleanContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocSourceArr(EsParser.QueryDataStatementMGETDocSourceArrContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocSourceObj(EsParser.QueryDataStatementMGETDocSourceObjContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementMGETDocIncldue(), ctx.queryDataStatementMGETDocExclude());
      return this.rparen();
   }

   public Printer visitQueryDataStatementMGETDocIncldue(EsParser.QueryDataStatementMGETDocIncldueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETDocExclude(EsParser.QueryDataStatementMGETDocExcludeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETStoredFields(EsParser.QueryDataStatementMGETStoredFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMGETIds(EsParser.QueryDataStatementMGETIdsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementMSearch(EsParser.QueryDataStatementMSearchContext ctx) {
      return this.visitHttpND(ctx, EsParser.QueryDataStatementMSearchBodyContext.class);
   }

   public Printer visitQueryDataStatementMSearchBody(EsParser.QueryDataStatementMSearchBodyContext ctx) {
      return this.visitObjectRuleContextList(ctx.children, "\n");
   }

   public Printer visitQueryDataStatementMSearchEmpty(EsParser.QueryDataStatementMSearchEmptyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementCount(EsParser.QueryDataStatementCountContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementCountBody(EsParser.QueryDataStatementCountBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementTermsEnum(EsParser.QueryDataStatementTermsEnumContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementTermsEnumBody(EsParser.QueryDataStatementTermsEnumBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementTermsEnumField(), ctx.queryDataStatementTermsEnumValue(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementTermsEnumField(EsParser.QueryDataStatementTermsEnumFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementTermsEnumValue(EsParser.QueryDataStatementTermsEnumValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementExplain(EsParser.QueryDataStatementExplainContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementExplainBody(EsParser.QueryDataStatementExplainBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementFieldCaps(EsParser.QueryDataStatementFieldCapsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementFieldCapsBody(EsParser.QueryDataStatementFieldCapsBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyRuntimeMappings(), ctx.queryDataStatementFieldCapsBodyIndexFiter());
      return this.rparen();
   }

   public Printer visitQueryDataStatementFieldCapsBodyIndexFiter(EsParser.QueryDataStatementFieldCapsBodyIndexFiterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementRankEval(EsParser.QueryDataStatementRankEvalContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementRankEvalBody(EsParser.QueryDataStatementRankEvalBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementRankEvalRequests(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementRankEvalRequests(EsParser.QueryDataStatementRankEvalRequestsContext ctx) {
      this.visit(ctx.REQUESTS());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.queryDataStatementRankEvalRequestBody());
      return this.rsquare();
   }

   public Printer visitQueryDataStatementRankEvalRequestBody(EsParser.QueryDataStatementRankEvalRequestBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementRankEvalRequest(), ctx.queryDataStatementRankEvalRatings(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementRankEvalRequest(EsParser.QueryDataStatementRankEvalRequestContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementRankEvalRatings(EsParser.QueryDataStatementRankEvalRatingsContext ctx) {
      this.visit(ctx.RATINGS());
      this.lsquare();
      this.visitObjectRuleContextList(ctx.queryDataStatementRankEvalRating());
      return this.rsquare();
   }

   public Printer visitQueryDataStatementRankEvalRating(EsParser.QueryDataStatementRankEvalRatingContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementRankEvalRatingIndex(), ctx.queryDataStatementRankEvalRatingId(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementRankEvalRatingIndex(EsParser.QueryDataStatementRankEvalRatingIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementRankEvalRatingId(EsParser.QueryDataStatementRankEvalRatingIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearch(EsParser.QueryDataStatementSearchContext ctx) {
      return this.visitHttp(ctx, EsParser.QueryDataStatementSearchBodyContext.class);
   }

   public Printer visitQueryDataStatementSearchBody(EsParser.QueryDataStatementSearchBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyDocValueFields(), ctx.pairs(), ctx.queryDataStatementSearchBodyFields(), ctx.queryDataStatementSearchBodyQuery(), ctx.queryDataStatementSearchBodyRuntimeMappings(), ctx.queryDataStatementSearchBodySource(), ctx.queryDataStatementSearchBodyAgg(), ctx.queryDataStatementSearchBodyStoredFields(), ctx.queryDataStatementSearchBodyIndicesBoost(), ctx.queryDataStatementSearchBodyIndexTypes());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyDocValueFields(EsParser.QueryDataStatementSearchBodyDocValueFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldExpr(EsParser.FieldExprContext ctx) {
      return this.visitObjectRuleContextList(ctx.field());
   }

   public Printer visitField(EsParser.FieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldString(EsParser.FieldStringContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldObj(EsParser.FieldObjContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyStoredFields(EsParser.QueryDataStatementSearchBodyStoredFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyIndicesBoost(EsParser.QueryDataStatementSearchBodyIndicesBoostContext ctx) {
      this.visit(ctx.INDICES_BOOST());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyIndicesBoostItem(), ctx.pairs());
      return this.rsquare();
   }

   public Printer visitQueryDataStatementSearchBodyIndicesBoostItem(EsParser.QueryDataStatementSearchBodyIndicesBoostItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyIndexTypes(EsParser.QueryDataStatementSearchBodyIndexTypesContext ctx) {
      return this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyIndex(), ctx.queryDataStatementSearchBodyType());
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappings(EsParser.QueryDataStatementSearchBodyRuntimeMappingsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappingObj(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjContext ctx) {
      this.visit(ctx.RUNTIME_MAPPINGS1());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyRuntimeMappingObjFieldExpr());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappingObjFieldExpr(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjFieldExprContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyRuntimeMappingObjFieldExprType(), ctx.queryDataStatementSearchBodyRuntimeMappingObjFieldExprScript());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappingObjFieldExprType(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjFieldExprTypeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappingObjFieldExprScript(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjFieldExprScriptContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyRuntimeMappingsArr(EsParser.QueryDataStatementSearchBodyRuntimeMappingsArrContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRunTimeMappingFieldExprs(EsParser.RunTimeMappingFieldExprsContext ctx) {
      return this.visitObjectRuleContextList(ctx.runtimeMappingField());
   }

   public Printer visitRuntimeMappingField(EsParser.RuntimeMappingFieldContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.string(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyQuery(EsParser.QueryDataStatementSearchBodyQueryContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyFields(EsParser.QueryDataStatementSearchBodyFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodyAgg(EsParser.QueryDataStatementSearchBodyAggContext ctx) {
      this.visit(ctx.AGGS());
      this.visit(ctx.AGGREGATIONS());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryDataStatementSearchBodyAggBody());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchBodyAggBody(EsParser.QueryDataStatementSearchBodyAggBodyContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.aggs(), ctx.queryDataStatementSearchBodyAgg(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitQueryDataStatementSearchSort(EsParser.QueryDataStatementSearchSortContext ctx) {
      this.visit(ctx.SORT());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.sortField());
      return this.rparen();
   }

   public Printer visitSortField(EsParser.SortFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryDataStatementSearchBodySource(EsParser.QueryDataStatementSearchBodySourceContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSourceFieldExpr(EsParser.SourceFieldExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSourceFieldBoolenExpr(EsParser.SourceFieldBoolenExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSourceFieldWildcardPatternExpr(EsParser.SourceFieldWildcardPatternExprContext ctx) {
      this.visit(ctx.fieldName);
      return this.visit(ctx.fieldNames);
   }

   public Printer visitSourceFieldObjectExpr(EsParser.SourceFieldObjectExprContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.sourceFieldIncludeExpr(), ctx.sourceFieldExcludeExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSourceFieldIncludeExpr(EsParser.SourceFieldIncludeExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSourceFieldExcludeExpr(EsParser.SourceFieldExcludeExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitInsertDataStatement(EsParser.InsertDataStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitInsertDataStatementForm1(EsParser.InsertDataStatementForm1Context ctx) {
      return this.visitHttp(ctx, EsParser.CuDataStatementBodyContext.class);
   }

   public Printer visitInsertDataStatementForm2(EsParser.InsertDataStatementForm2Context ctx) {
      return this.visitHttp(ctx, EsParser.CuDataStatementBodyContext.class);
   }

   public Printer visitUpdateDataStatement(EsParser.UpdateDataStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUpdateDataStatementById(EsParser.UpdateDataStatementByIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUpdateDataStatementPart1(EsParser.UpdateDataStatementPart1Context ctx) {
      return this.visitHttp(ctx, EsParser.CuDataStatementBodyContext.class);
   }

   public Printer visitUpdateDataStatementPart2(EsParser.UpdateDataStatementPart2Context ctx) {
      return this.visitHttp(ctx, EsParser.CuDataStatementBodyContext.class);
   }

   public Printer visitUpdateDataStatementByQuery(EsParser.UpdateDataStatementByQueryContext ctx) {
      return this.visitHttp(ctx, EsParser.UpdateDataStatementByQueryBodyContext.class);
   }

   public Printer visitUpdateDataStatementByQueryBody(EsParser.UpdateDataStatementByQueryBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitDeleteDataStatement(EsParser.DeleteDataStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDeleteDataByIdStatement(EsParser.DeleteDataByIdStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDeleteDataByQueryStatement(EsParser.DeleteDataByQueryStatementContext ctx) {
      return this.visitHttp(ctx, EsParser.QueryBodyContext.class);
   }

   public Printer visitCuDataStatementBody(EsParser.CuDataStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCuDataStatementValue(EsParser.CuDataStatementValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCuDataStatementObjValue(EsParser.CuDataStatementObjValueContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.cuDataStatementObjValuePair());
      return this.rparen();
   }

   public Printer visitCuDataStatementArrayValue(EsParser.CuDataStatementArrayValueContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.cuDataStatementValue());
      return this.rsquare();
   }

   public Printer visitCuDataStatementObjValuePair(EsParser.CuDataStatementObjValuePairContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCuDataStatementFieldScript(EsParser.CuDataStatementFieldScriptContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryBody(EsParser.QueryBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryFilter(EsParser.QueryFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitComboundFilter(EsParser.ComboundFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitNsetedFilter(EsParser.NsetedFilterContext ctx) {
      this.visit(ctx.NESTED());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.nsetedFilterItem());
      return this.rparen();
   }

   public Printer visitNsetedFilterItem(EsParser.NsetedFilterItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitNsetedFilterItemPath(EsParser.NsetedFilterItemPathContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBoostingFilter(EsParser.BoostingFilterContext ctx) {
      this.visit(ctx.BOOSTING());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.boostingFilterBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitBoostingFilterBody(EsParser.BoostingFilterBodyContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitHasChildFilter(EsParser.HasChildFilterContext ctx) {
      this.visit(ctx.HAS_CHILD());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitHasParentFilter(EsParser.HasParentFilterContext ctx) {
      this.visit(ctx.HAS_PARENT());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitParentIdFilter(EsParser.ParentIdFilterContext ctx) {
      this.visit(ctx.PARENT_ID());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitBoolFilter(EsParser.BoolFilterContext ctx) {
      this.visit(ctx.BOOL());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitMustFilter(EsParser.MustFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMustFilterN(EsParser.MustFilterNContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.mustFilter1());
      return this.rsquare();
   }

   public Printer visitMustFilter1(EsParser.MustFilter1Context ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitFilterFilter(EsParser.FilterFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterFilterN(EsParser.FilterFilterNContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.filterFilter1());
      return this.rsquare();
   }

   public Printer visitFilterFilter1(EsParser.FilterFilter1Context ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitShouldFilter(EsParser.ShouldFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitShouldFilterN(EsParser.ShouldFilterNContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.shouldFilter1());
      return this.rsquare();
   }

   public Printer visitShouldFilter1(EsParser.ShouldFilter1Context ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitConstantScoreFilter(EsParser.ConstantScoreFilterContext ctx) {
      this.visit(ctx.CONSTANT_SCORE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitDismaxFilter(EsParser.DismaxFilterContext ctx) {
      this.visit(ctx.DIS_MAX());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.dismaxFilterQueriesBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitDismaxFilterQueriesBody(EsParser.DismaxFilterQueriesBodyContext ctx) {
      this.visit(ctx.QUERIES());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.dismaxFilterQueriesBodyItems());
      return this.rsquare();
   }

   public Printer visitDismaxFilterQueriesBodyItems(EsParser.DismaxFilterQueriesBodyItemsContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.comboundFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitFunctionScoreFilter(EsParser.FunctionScoreFilterContext ctx) {
      this.visit(ctx.FUNCTION_SCORE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryBody(), ctx.queryFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitLeafFilter(EsParser.LeafFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitLeafMatchAllFilter(EsParser.LeafMatchAllFilterContext ctx) {
      this.visit(ctx.MATCH_ALL());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitLeafMatchNoneFilter(EsParser.LeafMatchNoneFilterContext ctx) {
      this.visit(ctx.MATCH_NONE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitLeafMatchFilter(EsParser.LeafMatchFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilter(EsParser.IntervalFilterContext ctx) {
      this.visit(ctx.INTERVALS());
      this.lparen1();
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterItem());
      this.rparen();
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleAnyOf(EsParser.IntervalFilterRuleAnyOfContext ctx) {
      this.visit(ctx.ANYOF());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRuleFilter(), ctx.intervalFilterRuleInterval());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleAllOf(EsParser.IntervalFilterRuleAllOfContext ctx) {
      this.visit(ctx.ALLOF());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRuleFilter(), ctx.intervalFilterRuleInterval(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleMatch(EsParser.IntervalFilterRuleMatchContext ctx) {
      this.visit(ctx.MATCH());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRuleFilter(), ctx.intervalFilterRuleMatchQuery(), ctx.pairs(), ctx.intervalFilterRuleMatchUseField());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleMatchQuery(EsParser.IntervalFilterRuleMatchQueryContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterRuleMatchUseField(EsParser.IntervalFilterRuleMatchUseFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterRulePrefix(EsParser.IntervalFilterRulePrefixContext ctx) {
      this.visit(ctx.PREFIX());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRulePrefixPrefix(), ctx.intervalFilterRuleMatchUseField(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitIntervalFilterRulePrefixPrefix(EsParser.IntervalFilterRulePrefixPrefixContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterRuleWildcard(EsParser.IntervalFilterRuleWildcardContext ctx) {
      this.visit(ctx.WILDCARD());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRuleWildcardPattern(), ctx.intervalFilterRuleMatchUseField(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleWildcardPattern(EsParser.IntervalFilterRuleWildcardPatternContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterRuleFuzzy(EsParser.IntervalFilterRuleFuzzyContext ctx) {
      this.visit(ctx.FUZZY());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterRuleMatchUseField(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleFilter(EsParser.IntervalFilterRuleFilterContext ctx) {
      this.visit(ctx.FILTER());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitIntervalFilterRuleInterval(EsParser.IntervalFilterRuleIntervalContext ctx) {
      this.visit(ctx.INTERVALS());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.intervalFilterIntervalItem());
      return this.rparen();
   }

   public Printer visitIntervalFilterItem(EsParser.IntervalFilterItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalItem(EsParser.IntervalFilterIntervalItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRuleAnyOf(EsParser.IntervalFilterIntervalRuleAnyOfContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRuleAllOf(EsParser.IntervalFilterIntervalRuleAllOfContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRuleMatch(EsParser.IntervalFilterIntervalRuleMatchContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRulePrefix(EsParser.IntervalFilterIntervalRulePrefixContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRuleWildcard(EsParser.IntervalFilterIntervalRuleWildcardContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIntervalFilterIntervalRuleFuzzy(EsParser.IntervalFilterIntervalRuleFuzzyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterMatch(EsParser.FilterMatchContext ctx) {
      this.visit(ctx.MATCH());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterMatchBoolPrefix(EsParser.FilterMatchBoolPrefixContext ctx) {
      this.visit(ctx.MATCH_BOOL_PREFIX());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterMatchPhrase(EsParser.FilterMatchPhraseContext ctx) {
      this.visit(ctx.MATCH_PHRASE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterMatchPhrasePrefix(EsParser.FilterMatchPhrasePrefixContext ctx) {
      this.visit(ctx.MATCH_PHRASE_PREFIX());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterCombinedFields(EsParser.FilterCombinedFieldsContext ctx) {
      this.visit(ctx.COMBINED_FIELDS());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterMultiMatch(EsParser.FilterMultiMatchContext ctx) {
      this.visit(ctx.MULTI_MATCH());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterCommon(EsParser.FilterCommonContext ctx) {
      this.visit(ctx.COMMON());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterQueryString(EsParser.FilterQueryStringContext ctx) {
      this.visit(ctx.QUERY_STRING());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterSimpleQueryString(EsParser.FilterSimpleQueryStringContext ctx) {
      this.visit(ctx.SIMPLE_QUERY_STRING());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldQueryFilter());
      return this.rparen();
   }

   public Printer visitLeafTermFilter(EsParser.LeafTermFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterExists(EsParser.FilterExistsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterFuzzy(EsParser.FilterFuzzyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldFuzzyExactFilter(EsParser.FieldFuzzyExactFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterTermFilter(EsParser.FilterTermFilterContext ctx) {
      this.visit(ctx.TERM());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitFilterIds(EsParser.FilterIdsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterPrefix(EsParser.FilterPrefixContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRangeFilter(EsParser.RangeFilterContext ctx) {
      this.visit(ctx.RANGE());
      this.lparen1();
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs(), ctx.rangeFilterGT(), ctx.rangeFilterLT());
      this.rparen();
      return this.rparen();
   }

   public Printer visitRangeFilterGT(EsParser.RangeFilterGTContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRangeFilterLT(EsParser.RangeFilterLTContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRegexpFilter(EsParser.RegexpFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsFilter(EsParser.TermsFilterContext ctx) {
      this.visit(ctx.TERMS());
      this.colon();
      List<ParserRuleContext> children = new SimpleList<ParserRuleContext>();
      if (ctx.termsFilterFieldN() != null) {
         children.add(ctx.termsFilterFieldN());
      }

      if (ctx.termsFilterField1() != null) {
         children.add(ctx.termsFilterField1());
      }

      return this.visitObjectRuleContextList(children);
   }

   public Printer visitTermsFilterField1(EsParser.TermsFilterField1Context ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.termsFilterField());
      return this.rparen();
   }

   public Printer visitTermsFilterFieldN(EsParser.TermsFilterFieldNContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.termsFilterFieldNItem());
      return this.rsquare();
   }

   public Printer visitTermsFilterFieldNItem(EsParser.TermsFilterFieldNItemContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitTermsFilterField(EsParser.TermsFilterFieldContext ctx) {
      return this.visitObjectRuleContextList(ctx.termsFilterFieldItem1(), ctx.termsFilterFieldItem(), ctx.termsFilterFieldItem1(), ctx.pairs());
   }

   public Printer visitTermsFilterFieldItem1(EsParser.TermsFilterFieldItem1Context ctx) {
      return this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
   }

   public Printer visitTermsFilterFieldItem(EsParser.TermsFilterFieldItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsFilterFieldValueString(EsParser.TermsFilterFieldValueStringContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsFilterFieldValueArray(EsParser.TermsFilterFieldValueArrayContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsFilterFieldValueLookup(EsParser.TermsFilterFieldValueLookupContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.pathExpr(), ctx.idExpr(), ctx.indexExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitTermsFilterFieldNameArray(EsParser.TermsFilterFieldNameArrayContext ctx) {
      this.visit(ctx.fieldName);
      this.colon();
      this.lsquare();
      this.visitObjectRuleContextList(ctx.string());
      return this.rsquare();
   }

   public Printer visitIndexExpr(EsParser.IndexExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPathExpr(EsParser.PathExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIdExpr(EsParser.IdExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsetFilter(EsParser.TermsetFilterContext ctx) {
      this.visit(ctx.TERMS_SET());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.termsetFilterItem());
      return this.rparen();
   }

   public Printer visitTermsetFilterItem(EsParser.TermsetFilterItemContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.termsetFilterTerms());
      return this.rparen();
   }

   public Printer visitTermsetFilterTerms(EsParser.TermsetFilterTermsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermTypeFilter(EsParser.TermTypeFilterContext ctx) {
      this.visit(ctx.TYPE2());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitWildcardFilter(EsParser.WildcardFilterContext ctx) {
      this.visit(ctx.WILDCARD());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldFilter());
      return this.rparen();
   }

   public Printer visitLeafGeoFilter(EsParser.LeafGeoFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoBoundingBoxFilter(EsParser.GeoBoundingBoxFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoBoundingBoxFilterField(EsParser.GeoBoundingBoxFilterFieldContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitGeoDistanceFilter(EsParser.GeoDistanceFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoDistanceFilterField(EsParser.GeoDistanceFilterFieldContext ctx) {
      return this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
   }

   public Printer visitGeoPolygonFilter(EsParser.GeoPolygonFilterContext ctx) {
      this.visit(ctx.GEO_POLYGON());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.geoPolygonFilterField());
      return this.rparen();
   }

   public Printer visitGeoPolygonFilterField(EsParser.GeoPolygonFilterFieldContext ctx) {
      if (ctx.v1 != null) {
         this.visit(ctx.NAME1());
         this.colon();
         this.visit(ctx.v1);
      }

      if (ctx.v2 != null) {
         this.visit(ctx.VALIDATION_METHOD());
         this.colon();
         this.visit(ctx.v2);
      }

      if (ctx.fieldName != null) {
         this.visit(ctx.fieldName);
         this.colon();
         this.visit(ctx.jvalue());
      }

      return this.output;
   }

   public Printer visitGeoShapeFilter(EsParser.GeoShapeFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoShapeFilterField(EsParser.GeoShapeFilterFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitLeafShapeFilter(EsParser.LeafShapeFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitShapeFilter(EsParser.ShapeFilterContext ctx) {
      this.visit(ctx.SHAPE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitSpanQuery(EsParser.SpanQueryContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanFilter(EsParser.SpanFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanNearFilter(EsParser.SpanNearFilterContext ctx) {
      this.visit(ctx.SPAN_NEAR());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.spanNearFilterClausesPart(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSpanNearFilterClausesPart(EsParser.SpanNearFilterClausesPartContext ctx) {
      this.visit(ctx.CLAUSES());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.spanNearFilterClausesPartItem());
      return this.rsquare();
   }

   public Printer visitSpanNotFilter(EsParser.SpanNotFilterContext ctx) {
      this.visit(ctx.SPAN_NOT());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.spanNotFilterIncludePart(), ctx.spanNotFilterExcludePart(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSpanNotFilterIncludePart(EsParser.SpanNotFilterIncludePartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanNotFilterExcludePart(EsParser.SpanNotFilterExcludePartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanOrFilter(EsParser.SpanOrFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanOrFilterClausesPart(EsParser.SpanOrFilterClausesPartContext ctx) {
      this.visit(ctx.CLAUSES());
      this.colon();
      this.lsquare();
      if (ctx.spanTermFilter() != null) {
         List<EsParser.SpanTermFilterContext> spanTermFilter = ctx.spanTermFilter();

         for(int i = 0; i < spanTermFilter.size() - 1; ++i) {
            this.lparen();
            this.visit((ParseTree)spanTermFilter.get(i));
            this.rparen();
            if (i != spanTermFilter.size() - 1) {
               this.comma();
            }
         }
      }

      return this.rsquare();
   }

   public Printer visitSpanTermFilter(EsParser.SpanTermFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanWithinFilter(EsParser.SpanWithinFilterContext ctx) {
      this.visit(ctx.SPAN_WITHIN());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.spanWithinFilterPart());
      return this.rparen();
   }

   public Printer visitSpanWithinFilterPart(EsParser.SpanWithinFilterPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanContainingFilter(EsParser.SpanContainingFilterContext ctx) {
      this.visit(ctx.SPAN_CONTAINING());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.spanContainingFilterPart());
      return this.rparen();
   }

   public Printer visitSpanContainingFilterPart(EsParser.SpanContainingFilterPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanFiledMaskingFilter(EsParser.SpanFiledMaskingFilterContext ctx) {
      this.visit(ctx.SPAN_FIELD_MASKING());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.spanQuery(), ctx.fieldSimpleFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSpanFirstFilter(EsParser.SpanFirstFilterContext ctx) {
      this.visit(ctx.SPAN_FIRST());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.spanFirstFilterPart(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSpanFirstFilterPart(EsParser.SpanFirstFilterPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSpanMultiFilter(EsParser.SpanMultiFilterContext ctx) {
      this.visit(ctx.SPAN_MULTI());
      this.colon();
      this.lparen();
      this.visit(ctx.MATCH());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.spanMultiFilterPart(), ctx.pairs());
      this.rparen();
      return this.rparen();
   }

   public Printer visitSpanMultiFilterPart(EsParser.SpanMultiFilterPartContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitLeafOtherFilter(EsParser.LeafOtherFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDistanceFeatureFilter(EsParser.DistanceFeatureFilterContext ctx) {
      this.visit(ctx.DISTANCE_FEATURE());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitMoreLikeThisFilter(EsParser.MoreLikeThisFilterContext ctx) {
      this.visit(ctx.MORE_LIKE_THIS());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldsNamesExpr(), ctx.fieldLikeExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitFieldValueExpr(EsParser.FieldValueExprContext ctx) {
      this.visit(ctx.fieldName);
      this.lparen1();
      List<ParserRuleContext> list = new SimpleList<ParserRuleContext>();
      list.addAll(ctx.fieldValueExpr1());
      list.addAll(ctx.pairs());
      this.visitObjectRuleContextList(list);
      return this.rparen();
   }

   public Printer visitFieldValueExpr1(EsParser.FieldValueExpr1Context ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPercolateFilter(EsParser.PercolateFilterContext ctx) {
      this.visit(ctx.PERCOLATE());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.fieldDocuments(), ctx.fieldDocument(), ctx.fieldIndex1(), ctx.fieldId1(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitRankFeatureFilter(EsParser.RankFeatureFilterContext ctx) {
      this.visit(ctx.RANK_FEATURE());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.fieldDocuments(), ctx.fieldDocument(), ctx.fieldIndex1(), ctx.fieldId1(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitScriptFilter(EsParser.ScriptFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitScriptFilterScriptSimple(EsParser.ScriptFilterScriptSimpleContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitScriptFilterSourceValue(EsParser.ScriptFilterSourceValueContext ctx) {
      this.lparen();
      List<EsParser.StringContext> string = ctx.string();
      if (string != null) {
         for(int i = 0; i < string.size(); ++i) {
            this.visit(ctx.SOURCE2(i));
            this.colon();
            this.visit((ParseTree)string.get(i));
            if (i != string.size() - 1) {
               this.comma();
            }
         }
      }

      List<EsParser.PairsContext> pairs = ctx.pairs();
      if (ctx.pairs() != null && pairs.size() > 0) {
         if (string != null) {
            this.comma();
         }

         for(int i = 0; i < pairs.size(); ++i) {
            this.visit((ParseTree)pairs.get(i));
            if (i != pairs.size() - 1) {
               this.comma();
            }
         }
      }

      return this.rparen();
   }

   public Printer visitScriptScoreFilter(EsParser.ScriptScoreFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPinnedFilter(EsParser.PinnedFilterContext ctx) {
      this.visit(ctx.PINNED());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.pinnedFilterDocs(), ctx.pinnedFilterOrganic(), ctx.pinnedFilterIds(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitPinnedFilterOrganic(EsParser.PinnedFilterOrganicContext ctx) {
      this.visit(ctx.ORGANIC());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.queryFilter());
      return this.rparen();
   }

   public Printer visitPinnedFilterDocs(EsParser.PinnedFilterDocsContext ctx) {
      this.visit(ctx.DOCS());
      this.colon();
      this.lsquare();
      this.visitObjectRuleContextList(ctx.pinnedFilterDocsItem());
      return this.rsquare();
   }

   public Printer visitPinnedFilterDocsItem(EsParser.PinnedFilterDocsItemContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldId(), ctx.fieldIndex(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitPinnedFilterIds(EsParser.PinnedFilterIdsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAggs(EsParser.AggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketAggs(EsParser.BucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitReindexStatement(EsParser.ReindexStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitReindexStatementBody(EsParser.ReindexStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitReindexStatementSection(EsParser.ReindexStatementSectionContext ctx) {
      this.visit(ctx.string());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.reindexStatementSectionIndex(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitReindexStatementSectionIndex(EsParser.ReindexStatementSectionIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermvectorsStatement(EsParser.TermvectorsStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermvectorsStaticStatement(EsParser.TermvectorsStaticStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermvectorsDynamicStatement(EsParser.TermvectorsDynamicStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermvectorsStatementBody(EsParser.TermvectorsStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermvectorsStatementBodyFields(EsParser.TermvectorsStatementBodyFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvecotrsStatement(EsParser.MtermvecotrsStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBody(EsParser.MtermvectorsStatementBodyContext ctx) {
      this.lparen();
      this.visit(ctx.string());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.mtermvectorsStatementBodyItem());
      this.rsquare();
      return this.rparen();
   }

   public Printer visitMtermvectorsStatementBodyItem(EsParser.MtermvectorsStatementBodyItemContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.mtermvectorsStatementBodyIndex(), ctx.mtermvectorsStatementBodyFields(), ctx.mtermvectorsStatementBodyId(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitMtermvectorsStatementBodyFields(EsParser.MtermvectorsStatementBodyFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBodyIndex(EsParser.MtermvectorsStatementBodyIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBodyId(EsParser.MtermvectorsStatementBodyIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBody1(EsParser.MtermvectorsStatementBody1Context ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.mtermvectorsStatementBody1Item(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitMtermvectorsStatementBody1Item(EsParser.MtermvectorsStatementBody1ItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBody1Ids(EsParser.MtermvectorsStatementBody1IdsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMtermvectorsStatementBody1Fields(EsParser.MtermvectorsStatementBody1FieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCreateEnrichStatement(EsParser.CreateEnrichStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCreateEnrichStatementBody(EsParser.CreateEnrichStatementBodyContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCreateEnrichStatementPolicyTypeIndices(EsParser.CreateEnrichStatementPolicyTypeIndicesContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCreateEnrichStatementPolicyTypeMatchField(EsParser.CreateEnrichStatementPolicyTypeMatchFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCreateEnrichStatementPolicyTypeEnrichFields(EsParser.CreateEnrichStatementPolicyTypeEnrichFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDeleteEnrichStatement(EsParser.DeleteEnrichStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGetEnrichStatement(EsParser.GetEnrichStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitExecuteEnrichStatement(EsParser.ExecuteEnrichStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitStatsEnrichStatement(EsParser.StatsEnrichStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAutoScalingCreateOrUpdateStatement(EsParser.AutoScalingCreateOrUpdateStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAutoScalingGetStatement(EsParser.AutoScalingGetStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAutoScalingGetPolicyStatement(EsParser.AutoScalingGetPolicyStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAutoScalingDeleteStatement(EsParser.AutoScalingDeleteStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCatStatement(EsParser.CatStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitClusterStatement(EsParser.ClusterStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitClusterClusterReplicationStatement(EsParser.ClusterClusterReplicationStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDataStreamStatement(EsParser.DataStreamStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFeaturesStatement(EsParser.FeaturesStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFleetStatement(EsParser.FleetStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUriPrefixExpr(EsParser.UriPrefixExprContext ctx) {
      if (ctx.uriSeg() != null) {
         List<EsParser.UriSegContext> uriSeg = ctx.uriSeg();

         for(int i = 0; i < uriSeg.size(); ++i) {
            this.output.append('/');
            this.visit((ParseTree)uriSeg.get(i));
            if (i != uriSeg.size() - 1) {
               this.comma();
            }
         }
      }

      return this.output;
   }

   public Printer visitUriAppendixExpr(EsParser.UriAppendixExprContext ctx) {
      if (ctx.uriSeg() != null) {
         List<EsParser.UriSegContext> uriSeg = ctx.uriSeg();

         for(int i = 0; i < uriSeg.size(); ++i) {
            this.output.append('/');
            this.visit((ParseTree)uriSeg.get(i));
            if (i != uriSeg.size() - 1) {
               this.comma();
            }
         }
      }

      return this.output;
   }

   public Printer visitGraphStatement(EsParser.GraphStatementContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGraphStatementBody(EsParser.GraphStatementBodyContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.graphStatementVertices(), ctx.queryBody(), ctx.graphStatementConnections());
      return this.rparen();
   }

   public Printer visitGraphStatementConnections(EsParser.GraphStatementConnectionsContext ctx) {
      this.visit(ctx.CONNECTIONS());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.graphStatementVertices(), ctx.queryBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitGraphStatementVertices(EsParser.GraphStatementVerticesContext ctx) {
      this.visit(ctx.VERTICES());
      this.colon();
      this.lsquare();
      this.visitObjectRuleContextList(ctx.graphStatementVertice());
      return this.rsquare();
   }

   public Printer visitGraphStatementVertice(EsParser.GraphStatementVerticeContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.graphStatementVerticeExclude(), ctx.graphStatementVerticeField(), ctx.graphStatementVerticeInclude(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitGraphStatementVerticeField(EsParser.GraphStatementVerticeFieldContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGraphStatementVerticeInclude(EsParser.GraphStatementVerticeIncludeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGraphStatementVerticeExclude(EsParser.GraphStatementVerticeExcludeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAdjacencyMatrixAgg(EsParser.AdjacencyMatrixAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAdjacencyMatrixAggPart(EsParser.AdjacencyMatrixAggPartContext ctx) {
      if (ctx.string() != null && ctx.queryFilter() != null) {
         List<EsParser.StringContext> strings = ctx.string();
         List<EsParser.QueryFilterContext> queryFilter = ctx.queryFilter();

         for(int i = 0; i < strings.size(); ++i) {
            this.visit((ParseTree)strings.get(i));
            this.colon();
            this.lparen();
            this.visit((ParseTree)queryFilter.get(i));
            this.rparen();
            if (i != strings.size() - 1) {
               this.comma();
            }
         }
      }

      return this.output;
   }

   public Printer visitAutoDateHistogramAgg(EsParser.AutoDateHistogramAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCategorizeTextAgg(EsParser.CategorizeTextAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitChildrenAgg(EsParser.ChildrenAggContext ctx) {
      this.visit(ctx.CHILDREN());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitCompositeAgg(EsParser.CompositeAggContext ctx) {
      this.visit(ctx.COMPOSITE());
      this.colon();
      this.lparen();
      if (ctx.compositeAggItem() != null && ctx.compositeAggItem().size() != 0) {
         List<EsParser.CompositeAggItemContext> compositeAggItemContexts = ctx.compositeAggItem();
         this.visit(ctx.SOURCES(0));
         this.colon();
         this.lsquare();

         for(int i = 0; i < compositeAggItemContexts.size(); ++i) {
            this.visit((ParseTree)compositeAggItemContexts.get(i));
            if (i != compositeAggItemContexts.size() - 1) {
               this.comma();
            }
         }

         this.rsquare();
      }

      if (ctx.pairs() != null && ctx.pairs().size() != 0) {
         List<EsParser.PairsContext> pairs = ctx.pairs();
         if (ctx.compositeAggItem() != null && ctx.compositeAggItem().size() != 0) {
            this.comma();

            for(int i = 0; i < pairs.size(); ++i) {
               this.visit((ParseTree)pairs.get(i));
               if (i != pairs.size() - 1) {
                  this.comma();
               }
            }
         }
      }

      return this.rparen();
   }

   public Printer visitCompositeAggItem(EsParser.CompositeAggItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDateHistogramAgg(EsParser.DateHistogramAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDateRangeAgg(EsParser.DateRangeAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDiversifiedSamplerAgg(EsParser.DiversifiedSamplerAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterAgg(EsParser.FilterAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFiltersAgg(EsParser.FiltersAggContext ctx) {
      this.visit(ctx.FILTERS());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.filtersAgg(), ctx.filtersAggBody(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitFiltersAggBody(EsParser.FiltersAggBodyContext ctx) {
      if (ctx.string() != null && ctx.queryFilter() != null) {
         List<EsParser.StringContext> strings = ctx.string();
         List<EsParser.QueryFilterContext> querys = ctx.queryFilter();

         for(int i = 0; i < ctx.queryFilter().size(); ++i) {
            this.visit((ParseTree)strings.get(i));
            this.colon();
            this.lparen();
            this.visit((ParseTree)querys.get(i));
            this.rparen();
            if (i != strings.size() - 1) {
               this.comma();
            }
         }
      }

      return this.output;
   }

   public Printer visitGeoDistanceAgg(EsParser.GeoDistanceAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoHashGridAgg(EsParser.GeoHashGridAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoTileGridAgg(EsParser.GeoTileGridAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitHistogramAgg(EsParser.HistogramAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitIpRangeAgg(EsParser.IpRangeAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMissingAgg(EsParser.MissingAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMultiTermsAgg(EsParser.MultiTermsAggContext ctx) {
      this.visit(ctx.MULTI_TERMS());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.termsFilter(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitNestedAgg(EsParser.NestedAggContext ctx) {
      this.visit(ctx.NESTED());
      this.lparen();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitParentAgg(EsParser.ParentAggContext ctx) {
      this.visit(ctx.PARENT());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.pairs());
      return this.rparen();
   }

   public Printer visitRangeAgg(EsParser.RangeAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRangeAggItem(EsParser.RangeAggItemContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitRareTermsAgg(EsParser.RareTermsAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitReverseNestedAgg(EsParser.ReverseNestedAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSamplerAgg(EsParser.SamplerAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSignificantCrimeTypesAgg(EsParser.SignificantCrimeTypesAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSignificantTextAgg(EsParser.SignificantTextAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSignificantTermsAgg(EsParser.SignificantTermsAggContext ctx) {
      this.visit(ctx.SIGNIFICANT_TERMS());
      this.colon();
      this.lparen();
      this.visitObjectRuleContextList(ctx.aggBackgroundFilter(), ctx.fieldNameExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitAggBackgroundFilter(EsParser.AggBackgroundFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTermsAgg(EsParser.TermsAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitVariableWidthHistogramAgg(EsParser.VariableWidthHistogramAggContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMetricsAggs(EsParser.MetricsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAvgAggs(EsParser.AvgAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBoxplotAggs(EsParser.BoxplotAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCardinalityAggs(EsParser.CardinalityAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitExtendedStatsAggs(EsParser.ExtendedStatsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoBoundsAggs(EsParser.GeoBoundsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoCentroidAggs(EsParser.GeoCentroidAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitGeoLineAggs(EsParser.GeoLineAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMatrixStatsAggs(EsParser.MatrixStatsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMatrixStatsAggsPart(EsParser.MatrixStatsAggsPartContext ctx) {
      List<TerminalNode> fields = ctx.FIELDS();
      if (ctx.fieldNames != null) {
         this.visit((ParseTree)fields.get(0));
         this.colon();
         this.visit(ctx.fieldNames);
      }

      List<EsParser.PairsContext> pairs = ctx.pairs();
      if (fields != null && fields.size() > 0 && pairs != null && pairs.size() > 0) {
         this.comma();
      }

      return this.visitObjectRuleContextList(pairs);
   }

   public Printer visitMaxAggs(EsParser.MaxAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMedianAbsoluteDeviationAggs(EsParser.MedianAbsoluteDeviationAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMinAggs(EsParser.MinAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPercentileRanksAggs(EsParser.PercentileRanksAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPercentilesAggs(EsParser.PercentilesAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitRateAggs(EsParser.RateAggsContext ctx) {
      this.visit(ctx.RATE());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.rateAggsItem());
      return this.rparen();
   }

   public Printer visitRateAggsItem(EsParser.RateAggsItemContext ctx) {
      this.visit(ctx.fieldNameExpr());
      List<ParserRuleContext> children = new SimpleList<ParserRuleContext>();
      children.add(ctx.fieldNameExpr());
      children.add(ctx.pairs());
      return this.visitObjectRuleContextList(children);
   }

   public Printer visitScriptedMetricAggs(EsParser.ScriptedMetricAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitStatsAggs(EsParser.StatsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitStringStatsAggs(EsParser.StringStatsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSumAggs(EsParser.SumAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTTestAggs(EsParser.TTestAggsContext ctx) {
      this.visit(ctx.T_TEST());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.tTestAggsItem(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitTTestAggsItem(EsParser.TTestAggsItemContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.queryFilter());
      return this.rparen();
   }

   public Printer visitTopHitsAggs(EsParser.TopHitsAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTopMetricsAggs(EsParser.TopMetricsAggsContext ctx) {
      this.visit(ctx.TOP_METRICS());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.topMetricsAggsItem(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitTopMetricsAggsItem(EsParser.TopMetricsAggsItemContext ctx) {
      return this.visitObjectRuleContextList(ctx.topMetricsAggSort(), ctx.topMetricsAggsMetrics());
   }

   public Printer visitTopMetricsAggSort(EsParser.TopMetricsAggSortContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTopMetricsAggsMetrics(EsParser.TopMetricsAggsMetricsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTopMetricsAggsMetricsItems(EsParser.TopMetricsAggsMetricsItemsContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.topMetricsAggsMetricsItem());
      return this.rsquare();
   }

   public Printer visitTopMetricsAggsMetricsItem(EsParser.TopMetricsAggsMetricsItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitTypesCountAggs(EsParser.TypesCountAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitWeightedAvgAggs(EsParser.WeightedAvgAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitWeightedAvgAggsItem(EsParser.WeightedAvgAggsItemContext ctx) {
      return this.visitObjectRuleContextList(ctx.weightedAvgAggsItemValue(), ctx.weightedAvgAggsItemWeight(), ctx.pairs());
   }

   public Printer visitWeightedAvgAggsItemValue(EsParser.WeightedAvgAggsItemValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitWeightedAvgAggsItemWeight(EsParser.WeightedAvgAggsItemWeightContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitValueCountAggs(EsParser.ValueCountAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPipeLineAggs(EsParser.PipeLineAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAverageBucketAggs(EsParser.AverageBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketScriptAggs(EsParser.BucketScriptAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketCountKsTestAggs(EsParser.BucketCountKsTestAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketCorreationAggs(EsParser.BucketCorreationAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketSelectorAggs(EsParser.BucketSelectorAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitBucketSortAggs(EsParser.BucketSortAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCumulativeCardinalityAggs(EsParser.CumulativeCardinalityAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitCumulativeSumAggs(EsParser.CumulativeSumAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDerivativeAggs(EsParser.DerivativeAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitExtendedStatsBucketAggs(EsParser.ExtendedStatsBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMaxBucketAggs(EsParser.MaxBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMinBucketAggs(EsParser.MinBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMovingAvgAggs(EsParser.MovingAvgAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMovingFnAggs(EsParser.MovingFnAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitMovingPercentilesAggs(EsParser.MovingPercentilesAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitNormalizeAggs(EsParser.NormalizeAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPercentilesBucketAggs(EsParser.PercentilesBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSerialDiffAggs(EsParser.SerialDiffAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitStatsBucketAggs(EsParser.StatsBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSumBucketAggs(EsParser.SumBucketAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitInferenceAggs(EsParser.InferenceAggsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitAggCommonPart(EsParser.AggCommonPartContext ctx) {
      return this.visitObjectRuleContextList(ctx.fieldNameExpr(), ctx.scriptExpr(), ctx.sortExpr(), ctx.pairs());
   }

   public Printer visitFieldFilter(EsParser.FieldFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldSimpleFilter(EsParser.FieldSimpleFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldExactFilter(EsParser.FieldExactFilterContext ctx) {
      this.visit(ctx.string());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.queryExpr(), ctx.valueExpr(), ctx.operatorExpr(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitFieldQueryFilter(EsParser.FieldQueryFilterContext ctx) {
      List<ParserRuleContext> list = new SimpleList<ParserRuleContext>();
      list.addAll(ctx.queryExpr());
      list.addAll(ctx.valueExpr());
      list.addAll(ctx.fieldsNamesExpr());
      list.addAll(ctx.pairs());
      list.addAll(ctx.fieldValueExpr());
      list.addAll(ctx.filterQueryFieldValue());
      return this.visitObjectRuleContextList(list);
   }

   public Printer visitFieldValueFilter(EsParser.FieldValueFilterContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFilterQueryFieldValue(EsParser.FilterQueryFieldValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldsNamesExpr(EsParser.FieldsNamesExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitQueryExpr(EsParser.QueryExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitValueExpr(EsParser.ValueExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldNameExpr(EsParser.FieldNameExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitOperatorExpr(EsParser.OperatorExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitDefaultExpr(EsParser.DefaultExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSourceFieldsExpr(EsParser.SourceFieldsExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSortExpr(EsParser.SortExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSortItems(EsParser.SortItemsContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.sortItem());
      return this.rsquare();
   }

   public Printer visitSortItem(EsParser.SortItemContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSortExprOptions(EsParser.SortExprOptionsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitScriptExpr(EsParser.ScriptExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldLikeExpr(EsParser.FieldLikeExprContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldLikeExprN(EsParser.FieldLikeExprNContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.fieldLikeExprValue());
      return this.rsquare();
   }

   public Printer visitFieldLikeExpr1(EsParser.FieldLikeExpr1Context ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldLikeExprValue(EsParser.FieldLikeExprValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldLikeExprValueObj(EsParser.FieldLikeExprValueObjContext ctx) {
      this.output.append('{');
      List<ParserRuleContext> children = new SimpleList<ParserRuleContext>();
      children.addAll(ctx.fieldIndex());
      children.addAll(ctx.fieldId());
      children.addAll(ctx.pairs());
      this.visitObjectRuleContextList(children);
      this.output.append('}');
      return this.output;
   }

   public Printer visitFieldLikeExprValueSimple(EsParser.FieldLikeExprValueSimpleContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldDocuments(EsParser.FieldDocumentsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldDocument(EsParser.FieldDocumentContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldDocumentValue(EsParser.FieldDocumentValueContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldIndex1(EsParser.FieldIndex1Context ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldId1(EsParser.FieldId1Context ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldIndex(EsParser.FieldIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitFieldId(EsParser.FieldIdContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitPairs(EsParser.PairsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUriSeg(EsParser.UriSegContext ctx) {
      List<EsParser.UriSegContext> uriSegContexts = ctx.uriSeg();
      if (uriSegContexts != null && uriSegContexts.size() > 0) {
         this.visitObjectRuleContextList(uriSegContexts, ",");
      } else {
         this.visitChildren(ctx);
      }

      return this.output;
   }

   public Printer visitUriSegIndex(EsParser.UriSegIndexContext ctx) {
      this.visit(ctx.uriIndexAtom());
      List<EsParser.UriSegContext> others = ctx.uriSeg();
      if (others != null && others.size() > 0) {
         this.comma();
      }

      this.visitObjectRuleContextList(others, ",");
      return this.output;
   }

   public Printer visitUriIndexAtom(EsParser.UriIndexAtomContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitUriFragments(EsParser.UriFragmentsContext ctx) {
      this.output.append('?');
      this.visit(ctx.uriFragmentSegments());
      this.output.append('\n');
      return this.output;
   }

   public Printer visitUriFragmentSegments(EsParser.UriFragmentSegmentsContext ctx) {
      List<EsParser.UriFragmentSegmentContext> uriFragmentSegmentContexts = ctx.uriFragmentSegment();
      if (uriFragmentSegmentContexts != null) {
         for(EsParser.UriFragmentSegmentContext uriFragmentSegmentContext : uriFragmentSegmentContexts) {
            this.visitChildren(uriFragmentSegmentContext);
            this.output.append('&');
         }
      }

      return this.output;
   }

   public Printer visitUriFragmentSegment(EsParser.UriFragmentSegmentContext ctx) {
      if (ctx.children != null) {
         for(ParseTree child : ctx.children) {
            this.output.append(child.getText());
         }
      }

      return this.output;
   }

   public Printer visitMappingResponse(EsParser.MappingResponseContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.mappingResponseMapping());
      return this.rparen();
   }

   public Printer visitMappingResponseMapping(EsParser.MappingResponseMappingContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponse(EsParser.SearchResponseContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponseItem(EsParser.SearchResponseItemContext ctx) {
      return this.visitObjectRuleContextList(ctx.searchResponseItemHits(), ctx.pairs());
   }

   public Printer visitSearchResponseItemHits(EsParser.SearchResponseItemHitsContext ctx) {
      this.visit(ctx.HITS());
      this.lparen1();
      this.visitObjectRuleContextList(ctx.searchResponseHitsHits(), ctx.pairs());
      return this.rparen();
   }

   public Printer visitSearchResponseHitsHits(EsParser.SearchResponseHitsHitsContext ctx) {
      this.visit(ctx.HITS());
      this.lsquare1();
      this.visitObjectRuleContextList(ctx.searchResponseHitsHitsMemo(), ctx.searchResponseHitsHitsFields(), ctx.pairs());
      return this.rsquare();
   }

   public Printer visitSearchResponseHitsHitsMemo(EsParser.SearchResponseHitsHitsMemoContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponseHitsHitsIndex(EsParser.SearchResponseHitsHitsIndexContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponseHitsHitsType(EsParser.SearchResponseHitsHitsTypeContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponseHitsHitsSource(EsParser.SearchResponseHitsHitsSourceContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitSearchResponseHitsHitsFields(EsParser.SearchResponseHitsHitsFieldsContext ctx) {
      return (Printer)this.visitChildren(ctx);
   }

   public Printer visitString(EsParser.StringContext ctx) {
      return this.output.append(ctx.getText());
   }

   public Printer visitObj(EsParser.ObjContext ctx) {
      this.lparen();
      this.visitObjectRuleContextList(ctx.pair());
      return this.rparen();
   }

   public Printer visitPair(EsParser.PairContext ctx) {
      this.visit(ctx.string());
      this.colon();
      return this.visit(ctx.jvalue());
   }

   public Printer visitStringArr(EsParser.StringArrContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.string());
      return this.rsquare();
   }

   public Printer visitArr(EsParser.ArrContext ctx) {
      this.lsquare();
      this.visitObjectRuleContextList(ctx.jvalue());
      return this.rsquare();
   }

   public Printer visitBool(EsParser.BoolContext ctx) {
      if (ctx.BOOLEAN_TRUE() != null) {
         this.output.append("true");
      } else {
         this.output.append("false");
      }

      return this.output;
   }

   public Printer visitJvalue(EsParser.JvalueContext ctx) {
      this.visit(ctx.NUMBER());
      this.visit(ctx.NULL());
      this.visit(ctx.obj());
      this.visit(ctx.arr());
      this.visit(ctx.string());
      this.visit(ctx.bool());
      return this.output;
   }

   private Printer visitPairsList(List<EsParser.PairsContext> pairs) {
      if (pairs != null && pairs.size() > 0) {
         for(EsParser.PairsContext pair : pairs) {
            this.visit(pair);
         }
      }

      return this.output;
   }

   private Printer visitStringsList(List<EsParser.StringContext> strings) {
      if (strings != null && strings.size() > 0) {
         for(EsParser.StringContext pair : strings) {
            this.visit(pair);
         }
      }

      return this.output;
   }

   private Printer visitRuleContextList(List<ParserRuleContext> values) {
      if (values != null && values.size() > 0) {
         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.visit(value);
            if (i != values.size() - 1) {
               this.output.append(',');
            }
         }
      }

      return this.output;
   }

   private Printer visitObjectRuleContextList(List values) {
      return this.visitObjectRuleContextList(values, ",");
   }

   private Printer visitObjectRuleContextList(List values, String padding) {
      if (values != null && values.size() > 0) {
         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.visit(value);
            if (i != values.size() - 1) {
               this.output.append(padding);
            }
         }
      }

      return this.output;
   }

   private Printer visitObjectRuleContextList(List... valuesList) {
      if (valuesList != null && valuesList.length != 0) {
         List values = new ArrayList();

         for(Object value : valuesList) {
            if (value instanceof List) {
               List<?> subList = (List)value;
               if (subList != null && !subList.isEmpty()) {
                  values.addAll(subList);
               }
            }
         }

         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.visit(value);
            if (i != values.size() - 1) {
               this.output.append(",");
            }
         }

         return this.output;
      } else {
         return this.output;
      }
   }

   private Printer visitObjectRuleContextList(String splitor, List... valuesList) {
      if (valuesList != null && valuesList.length != 0) {
         List values = new ArrayList();

         for(Object value : valuesList) {
            if (value instanceof List) {
               List<?> subList = (List)value;
               if (subList != null && !subList.isEmpty()) {
                  values.addAll(subList);
               }
            }
         }

         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.visit(value);
            if (i != values.size() - 1) {
               this.output.append(splitor);
            }
         }

         return this.output;
      } else {
         return this.output;
      }
   }

   private Printer visitWrapObjectRuleContextList(List values) {
      if (values != null && values.size() > 0) {
         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.output.append('{');
            this.visit(value);
            this.output.append('}');
            if (i != values.size() - 1) {
               this.output.append(',');
            }
         }
      }

      return this.output;
   }

   public Printer visit(ParseTree tree) {
      if (tree == null) {
         return this.output;
      } else {
         super.visit(tree);
         return this.output;
      }
   }

   public Printer visitTerminal(TerminalNode node) {
      this.output.append(node.getText());
      switch (node.getSymbol().getType()) {
         case 1:
         case 2:
         case 3:
         case 4:
         case 5:
         case 6:
            this.output.append(" ");
         default:
            return this.output;
      }
   }

   public Printer defaultResult() {
      return this.output;
   }

   Printer line() {
      return this.output.append('\n');
   }

   Printer colon() {
      return this.output.append(':');
   }

   Printer lsquare() {
      return this.output.append('[');
   }

   Printer lsquare1() {
      return this.output.append(": [");
   }

   Printer rsquare() {
      return this.output.append(']');
   }

   Printer lparen() {
      return this.output.append('{');
   }

   Printer lparen1() {
      return this.output.append(": {");
   }

   Printer rparen() {
      return this.output.append('}');
   }

   Printer comma() {
      return this.output.append(',');
   }

   Printer visitHttp(EsParserContextBase ctx, Class<?> cls) {
      for(ParseTree child : ctx.children) {
         if (child != null) {
            if (child.getClass().equals(cls)) {
               this.line();
            }

            this.visit(child);
         }
      }

      return this.output;
   }

   Printer visitHttpND(EsParserContextBase ctx, Class<?> cls) {
      for(ParseTree child : ctx.children) {
         if (child.getClass().equals(cls)) {
            this.line();
         }

         this.visit(child);
      }

      this.line();
      return this.output;
   }

   static class SimpleList<T> extends ArrayList<T> {
      public boolean addAll(Collection<? extends T> c) {
         return c != null && c.size() != 0 ? super.addAll(c) : false;
      }

      public boolean add(T e) {
         return e == null ? false : super.add(e);
      }
   }
}
